/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.factory;

import com.jerry.mekanism_extras.common.tier.AdvancedFactoryTier;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityItemToItemAdvancedFactory;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.upgrade.MetallurgicInfuserUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMetallurgicInfuserAdvancedFactory
extends TileEntityItemToItemAdvancedFactory<MetallurgicInfuserRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<InfuseType, InfusionStack, MetallurgicInfuserRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final IInputHandler<@NotNull InfusionStack> infusionInputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInfuseTypeItem"}, docPlaceholder="infusion extra input slot")
    InfusionInventorySlot extraSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInfuseType", "getInfuseTypeCapacity", "getInfuseTypeNeeded", "getInfuseTypeFilledPercentage"}, docPlaceholder="infusion buffer")
    IInfusionTank infusionTank;

    public TileEntityMetallurgicInfuserAdvancedFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.infusionInputHandler = InputHelper.getInputHandler((IChemicalTank)this.infusionTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
        this.configComponent.addSupported(TransmissionType.INFUSION);
        this.configComponent.setupIOConfig(TransmissionType.INFUSION, (Object)this.infusionTank, RelativeSide.RIGHT).setCanEject(false);
    }

    @NotNull
    public IChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> getInitialInfusionTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideInfusionWithConfig(() -> ((TileEntityMetallurgicInfuserAdvancedFactory)this).getDirection(), () -> ((TileEntityMetallurgicInfuserAdvancedFactory)this).getConfig());
        this.infusionTank = (IInfusionTank)ChemicalTankBuilder.INFUSION.create(1000L * (long)this.tier.processes * (long)this.tier.processes, arg_0 -> ((TileEntityMetallurgicInfuserAdvancedFactory)this).containsRecipeB(arg_0), this.markAllMonitorsChanged(listener));
        builder.addTank((IChemicalTank)this.infusionTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.extraSlot = InfusionInventorySlot.fillOrConvert((IInfusionTank)this.infusionTank, () -> ((TileEntityMetallurgicInfuserAdvancedFactory)this).m_58904_(), (IContentsListener)listener, (int)7, (int)57);
        builder.addSlot((IInventorySlot)this.extraSlot);
    }

    public IInfusionTank getInfusionTank() {
        return this.infusionTank;
    }

    @Nullable
    protected InfusionInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @Override
    protected int getNeededInput(MetallurgicInfuserRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount((Object)inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<MetallurgicInfuserRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            MetallurgicInfuserRecipe cachedRecipe = (MetallurgicInfuserRecipe)cached.getRecipe();
            return cachedRecipe.getItemInput().testType((Object)stack) && (this.infusionTank.isEmpty() || ((ChemicalStackIngredient.InfusionStackIngredient)cachedRecipe.getChemicalInput()).testType((Chemical)((InfuseType)this.infusionTank.getType())));
        }
        return false;
    }

    @Override
    protected MetallurgicInfuserRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        InfusionStack stored = (InfusionStack)this.infusionTank.getStack();
        ItemStack output = outputSlot.getStack();
        return (MetallurgicInfuserRecipe)((InputRecipeCache.ItemChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, (Object)fallbackInput, (Object)stored, recipe -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput(fallbackInput, (ChemicalStack)stored), (ItemStack)output));
    }

    @Override
    protected void handleSecondaryFuel() {
        this.extraSlot.fillTankOrConvert();
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<MetallurgicInfuserRecipe, InputRecipeCache.ItemChemical<InfuseType, InfusionStack, MetallurgicInfuserRecipe>> getRecipeType() {
        return MekanismRecipeType.METALLURGIC_INFUSING;
    }

    @Nullable
    public MetallurgicInfuserRecipe getRecipe(int cacheIndex) {
        return (MetallurgicInfuserRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.infusionInputHandler);
    }

    @NotNull
    public CachedRecipe<MetallurgicInfuserRecipe> createNewCachedRecipe(@NotNull MetallurgicInfuserRecipe recipe, int cacheIndex) {
        return TwoInputCachedRecipe.itemChemicalToItem((ItemStackChemicalToItemStackRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.inputHandlers[cacheIndex], this.infusionInputHandler, (IOutputHandler)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityMetallurgicInfuserAdvancedFactory)this).markForSave()).setBaselineMaxOperations(() -> switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case AdvancedFactoryTier.ABSOLUTE -> 8 * this.baselineMaxOperations;
            case AdvancedFactoryTier.SUPREME -> 16 * this.baselineMaxOperations;
            case AdvancedFactoryTier.COSMIC -> 32 * this.baselineMaxOperations;
            case AdvancedFactoryTier.INFINITE -> 64 * this.baselineMaxOperations;
        }).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof MetallurgicInfuserUpgradeData) {
            MetallurgicInfuserUpgradeData data = (MetallurgicInfuserUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.infusionTank.deserializeNBT(data.stored.serializeNBT());
            this.extraSlot.deserializeNBT(data.infusionSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public MetallurgicInfuserUpgradeData getUpgradeData() {
        return new MetallurgicInfuserUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.infusionTank, this.extraSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.infusionTank.setEmpty();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Empty the contents of the infusion buffer into the environment")
    void dumpInfuseType() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dump();
    }
}

