/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.inventory.slot;

import com.jerry.mekanism_extras.common.tier.AdvancedFactoryTier;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class AdvancedFactoryChemicalInventorySlot
extends ChemicalInventorySlot<Gas, GasStack> {
    private static AdvancedFactoryTier isTier = AdvancedFactoryTier.ABSOLUTE;

    protected AdvancedFactoryChemicalInventorySlot(AdvancedFactoryTier tier, IChemicalTank chemicalTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(chemicalTank, worldSupplier, canExtract, canInsert, canInsert, listener, x, y);
        isTier = tier;
    }

    private static GasStack getPotentialConversion(@Nullable Level world, ItemStack itemStack) {
        return (GasStack)AdvancedFactoryChemicalInventorySlot.getPotentialConversion((IMekanismRecipeTypeProvider)MekanismRecipeType.GAS_CONVERSION, (Level)world, (ItemStack)itemStack, (ChemicalStack)GasStack.EMPTY);
    }

    public static AdvancedFactoryChemicalInventorySlot fillOrConvert(AdvancedFactoryTier tier, IGasTank gasTank, Supplier<Level> worldSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        Function<ItemStack, GasStack> potentialConversionSupplier = stack -> AdvancedFactoryChemicalInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack);
        return new AdvancedFactoryChemicalInventorySlot(tier, (IChemicalTank)gasTank, worldSupplier, AdvancedFactoryChemicalInventorySlot.getFillOrConvertExtractPredicate((IChemicalTank)gasTank, GasInventorySlot::getCapability, potentialConversionSupplier), AdvancedFactoryChemicalInventorySlot.getFillOrConvertInsertPredicate((IChemicalTank)gasTank, GasInventorySlot::getCapability, potentialConversionSupplier), stack -> {
            if (stack.getCapability(Capabilities.GAS_HANDLER).isPresent()) {
                return true;
            }
            GasStack gasConversion = AdvancedFactoryChemicalInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack);
            return !gasConversion.isEmpty() && gasTank.isValid((ChemicalStack)gasConversion);
        }, listener, x, y);
    }

    public int getLimit(ItemStack stack) {
        return !stack.m_41619_() && stack.getCapability(Capabilities.GAS_HANDLER).isPresent() ? stack.m_41741_() : 64 * AdvancedFactoryChemicalInventorySlot.isTier.processes;
    }

    @Nullable
    public static IGasHandler getCapability(ItemStack stack) {
        return (IGasHandler)AdvancedFactoryChemicalInventorySlot.getCapability((ItemStack)stack, (Capability)Capabilities.GAS_HANDLER);
    }

    @Nullable
    protected IChemicalHandler<Gas, GasStack> getCapability() {
        return AdvancedFactoryChemicalInventorySlot.getCapability(this.current);
    }
}

