/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.function.Function;
import mekanism.common.config.IMekanismConfig;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class ExtraModConfig
extends ModConfig {
    private static final ExtraConfigFileTypeHandler EXTRA_TOML = new ExtraConfigFileTypeHandler();
    private final IMekanismConfig mekanismExtraConfig;

    public ExtraModConfig(ModContainer container, IMekanismConfig config) {
        super(config.getConfigType(), (IConfigSpec)config.getConfigSpec(), container, "MekanismExtras/" + config.getFileName() + ".toml");
        this.mekanismExtraConfig = config;
    }

    public ConfigFileTypeHandler getHandler() {
        return EXTRA_TOML;
    }

    public void clearCache(ModConfigEvent event) {
        this.mekanismExtraConfig.clearCache(event instanceof ModConfigEvent.Unloading);
    }

    private static class ExtraConfigFileTypeHandler
    extends ConfigFileTypeHandler {
        private ExtraConfigFileTypeHandler() {
        }

        private static Path getPath(Path configBasePath) {
            if (configBasePath.endsWith("serverconfig")) {
                return FMLPaths.CONFIGDIR.get();
            }
            return configBasePath;
        }

        public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
            return super.reader(ExtraConfigFileTypeHandler.getPath(configBasePath));
        }

        public void unload(Path configBasePath, ModConfig config) {
            super.unload(ExtraConfigFileTypeHandler.getPath(configBasePath), config);
        }
    }
}

