/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.capabilities.fluid;

import com.jerry.mekanism_extras.common.tile.ExtraTileEntityFluidTank;
import java.util.Objects;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ExtraFluidTankFluidTank
extends BasicFluidTank {
    private final ExtraTileEntityFluidTank tile;
    private final boolean isCreative;
    private final IntSupplier rate;

    public static ExtraFluidTankFluidTank create(ExtraTileEntityFluidTank tile, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tile, "Fluid tank tile entity cannot be null");
        return new ExtraFluidTankFluidTank(tile, listener);
    }

    private ExtraFluidTankFluidTank(ExtraTileEntityFluidTank tile, @Nullable IContentsListener listener) {
        super(tile.tier.getStorage(), alwaysTrueBi, alwaysTrueBi, alwaysTrue, listener);
        this.tile = tile;
        this.rate = tile.tier::getOutput;
        this.isCreative = false;
    }

    protected int getRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsInt() : super.getRate(automationType);
    }

    public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        TileEntityFluidTank tileAbove;
        FluidStack remainder;
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            remainder = super.insert(stack, Action.SIMULATE, automationType);
            if (remainder.isEmpty()) {
                this.setStackUnchecked(new FluidStack(stack, this.getCapacity()));
            }
        } else {
            remainder = super.insert(stack, action.combine(!this.isCreative), automationType);
        }
        if (!remainder.isEmpty() && (tileAbove = (TileEntityFluidTank)WorldUtils.getTileEntity(TileEntityFluidTank.class, (BlockGetter)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_().m_7494_())) != null) {
            remainder = tileAbove.fluidTank.insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    public int growStack(int amount, Action action) {
        ExtraTileEntityFluidTank tileAbove;
        int grownAmount = super.growStack(amount, action);
        if (amount > 0 && grownAmount < amount && !this.tile.getActive() && (tileAbove = (ExtraTileEntityFluidTank)WorldUtils.getTileEntity(ExtraTileEntityFluidTank.class, (BlockGetter)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_().m_7494_())) != null) {
            int leftOverToInsert = amount - grownAmount;
            FluidStack remainder = tileAbove.fluidTank.insert(new FluidStack(this.stored, leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }

    public FluidStack extract(int amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    public int setStackSize(int amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

