/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.capabilities.chemical;

import com.jerry.mekanism_extras.common.config.LoadConfig;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityRadioactiveWasteBarrel;
import java.util.Objects;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.common.capabilities.chemical.variable.VariableCapacityChemicalTank;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.Nullable;

public class ExtraStackedWasteBarrel
extends VariableCapacityChemicalTank<Gas, GasStack>
implements IGasHandler,
IGasTank {
    private static final ChemicalAttributeValidator ATTRIBUTE_VALIDATOR = ChemicalAttributeValidator.createStrict((Class[])new Class[]{GasAttributes.Radiation.class});
    private final ExtraTileEntityRadioactiveWasteBarrel tile;

    public static ExtraStackedWasteBarrel create(ExtraTileEntityRadioactiveWasteBarrel tile, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tile, "Radioactive Waste Barrel tile entity cannot be null");
        return new ExtraStackedWasteBarrel(tile, listener);
    }

    protected ExtraStackedWasteBarrel(ExtraTileEntityRadioactiveWasteBarrel tile, @Nullable IContentsListener listener) {
        super((LongSupplier)LoadConfig.extraConfig.radioactiveWasteBarrelMaxGas, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrueBi, ChemicalTankBuilder.GAS.alwaysTrue, ATTRIBUTE_VALIDATOR, listener);
        this.tile = tile;
    }

    public GasStack insert(GasStack stack, Action action, AutomationType automationType) {
        ExtraTileEntityRadioactiveWasteBarrel tileAbove;
        GasStack remainder = (GasStack)super.insert((ChemicalStack)stack, action, automationType);
        if (!remainder.isEmpty() && (tileAbove = (ExtraTileEntityRadioactiveWasteBarrel)WorldUtils.getTileEntity(ExtraTileEntityRadioactiveWasteBarrel.class, (BlockGetter)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_().m_7494_())) != null) {
            remainder = tileAbove.getGasTank().insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    public long growStack(long amount, Action action) {
        ExtraTileEntityRadioactiveWasteBarrel tileAbove;
        long grownAmount = super.growStack(amount, action);
        if (amount > 0L && grownAmount < amount && !this.tile.getActive() && (tileAbove = (ExtraTileEntityRadioactiveWasteBarrel)WorldUtils.getTileEntity(ExtraTileEntityRadioactiveWasteBarrel.class, (BlockGetter)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_().m_7494_())) != null) {
            long leftOverToInsert = amount - grownAmount;
            GasStack remainder = tileAbove.getGasTank().insert(new GasStack((GasStack)this.stored, leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }
}

