/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.client.render.transmitter;

import com.jerry.mekanism_extras.common.content.network.transmitter.ExtraLogisticalTransporter;
import com.jerry.mekanism_extras.common.tier.transmitter.TPTier;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityLogisticalTransporterBase;
import com.jerry.mekanism_extras.common.util.ExtraTransporterUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ExtraRenderLogisticalTransporter
extends RenderTransmitterBase<ExtraTileEntityLogisticalTransporterBase> {
    private static final Map<Direction, MekanismRenderer.Model3D> cachedOverlays = new EnumMap<Direction, MekanismRenderer.Model3D>(Direction.class);
    private final ModelTransporterBox modelBox;
    private final LazyItemRenderer itemRenderer = new LazyItemRenderer();

    public ExtraRenderLogisticalTransporter(BlockEntityRendererProvider.Context context) {
        super(context);
        this.modelBox = new ModelTransporterBox(context.m_173585_());
    }

    public static void onStitch(TextureAtlas map) {
        cachedOverlays.clear();
    }

    protected void render(ExtraTileEntityLogisticalTransporterBase tile, float partialTick, PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, @NotNull ProfilerFiller profiler) {
        ExtraLogisticalTransporter transporter = (ExtraLogisticalTransporter)tile.getTransmitter();
        Collection inTransit = transporter.getTransit();
        BlockPos pos = tile.m_58899_();
        if (!inTransit.isEmpty()) {
            matrix.m_85836_();
            this.itemRenderer.init(tile.m_58904_(), pos);
            float partial = partialTick * (float)TPTier.getSpeed(transporter.tier);
            Collection<TransporterStack> reducedTransit = this.getReducedTransit(inTransit);
            for (TransporterStack stack : reducedTransit) {
                float[] stackPos = ExtraTransporterUtils.getStackPosition(transporter, stack, partial);
                matrix.m_85836_();
                matrix.m_252880_(stackPos[0], stackPos[1], stackPos[2]);
                matrix.m_85841_(0.75f, 0.75f, 0.75f);
                this.itemRenderer.renderAsStack(matrix, renderer, stack.itemStack, light);
                matrix.m_85849_();
                if (stack.color == null) continue;
                this.modelBox.render(matrix, renderer, 0xF000F0, overlayLight, stackPos[0], stackPos[1], stackPos[2], stack.color);
            }
            matrix.m_85849_();
        }
    }

    @NotNull
    protected String getProfilerSection() {
        return "logisticalTransporter";
    }

    private Collection<TransporterStack> getReducedTransit(Collection<TransporterStack> inTransit) {
        ArrayList<TransporterStack> reducedTransit = new ArrayList<TransporterStack>();
        ObjectOpenHashSet information = new ObjectOpenHashSet();
        for (TransporterStack stack : inTransit) {
            if (stack == null || stack.itemStack.m_41619_() || !information.add(new TransportInformation(stack))) continue;
            reducedTransit.add(stack);
        }
        return reducedTransit;
    }

    private static class LazyItemRenderer {
        @Nullable
        private ItemEntity entityItem;
        @Nullable
        private EntityRenderer<? super ItemEntity> renderer;

        private LazyItemRenderer() {
        }

        public void init(Level world, BlockPos pos) {
            if (this.entityItem == null) {
                this.entityItem = new ItemEntity(EntityType.f_20461_, world);
            } else {
                this.entityItem.m_284535_(world);
            }
            this.entityItem.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            this.entityItem.f_31985_ = 0;
        }

        private void renderAsStack(PoseStack matrix, MultiBufferSource buffer, ItemStack stack, int light) {
            if (this.entityItem != null) {
                if (this.renderer == null) {
                    this.renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.entityItem);
                }
                this.entityItem.m_32045_(stack);
                this.renderer.m_7392_((Entity)this.entityItem, 0.0f, 0.0f, matrix, buffer, light);
            }
        }
    }

    private static class TransportInformation {
        @Nullable
        private final EnumColor color;
        private final HashedItem item;
        private final int progress;

        private TransportInformation(TransporterStack transporterStack) {
            this.progress = transporterStack.progress;
            this.color = transporterStack.color;
            this.item = HashedItem.create((ItemStack)transporterStack.itemStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.progress;
            code = 31 * code + this.item.hashCode();
            if (this.color != null) {
                code = 31 * code + this.color.hashCode();
            }
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TransportInformation)) return false;
            TransportInformation other = (TransportInformation)obj;
            if (this.progress != other.progress) return false;
            if (this.color != other.color) return false;
            if (!this.item.equals((Object)other.item)) return false;
            return true;
        }
    }
}

