/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.client.render.tileentity;

import com.jerry.mekanism_extras.client.model.ExtraModelEnergyCore;
import com.jerry.mekanism_extras.common.tier.TierColor;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityEnergyCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.tileentity.ModelTileEntityRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ExtraRenderEnergyCube
extends ModelTileEntityRenderer<ExtraTileEntityEnergyCube, ExtraModelEnergyCore> {
    public static final Axis coreVec = Axis.m_253057_((Vector3f)new Vector3f(0.0f, MekanismUtils.ONE_OVER_ROOT_TWO, MekanismUtils.ONE_OVER_ROOT_TWO));

    public ExtraRenderEnergyCube(BlockEntityRendererProvider.Context context) {
        super(context, ExtraModelEnergyCore::new);
    }

    protected void render(final ExtraTileEntityEnergyCube tile, float partialTicks, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, final int overlayLight, @NotNull ProfilerFiller profiler) {
        final float energyScale = tile.getEnergyScale();
        final Vec3 renderPos = Vec3.m_82512_((Vec3i)tile.m_58899_());
        RenderTickHandler.addTransparentRenderer((RenderType)ExtraModelEnergyCore.BATCHED_RENDER_TYPE, (RenderTickHandler.LazyRender)new RenderTickHandler.LazyRender(){

            public void render(Camera camera, VertexConsumer buffer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
                float ticks = (float)renderTick + partialTick;
                float scaledTicks = 4.0f * ticks;
                poseStack.m_85836_();
                poseStack.m_85837_(renderPos.f_82479_, renderPos.f_82480_, renderPos.f_82481_);
                poseStack.m_85841_(0.4f, 0.4f, 0.4f);
                poseStack.m_85837_(0.0, Math.sin(Math.toRadians(3.0f * ticks)) / 7.0, 0.0);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(scaledTicks));
                poseStack.m_252781_(coreVec.m_252977_(36.0f + scaledTicks));
                ((ExtraModelEnergyCore)ExtraRenderEnergyCube.this.model).render(poseStack, buffer, 0xF000F0, overlayLight, TierColor.getColor(tile.getTier()), energyScale);
                poseStack.m_85849_();
            }

            public Vec3 getCenterPos(float partialTick) {
                return renderPos;
            }

            public String getProfilerSection() {
                return "energyCube.core";
            }
        });
    }

    @NotNull
    protected String getProfilerSection() {
        return "energyCube";
    }

    public boolean shouldRender(ExtraTileEntityEnergyCube tile, @NotNull Vec3 camera) {
        return tile.getTier().getMaxEnergy().intValue() > 0 && super.m_142756_((BlockEntity)tile, camera);
    }
}

