/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.common.config;

import java.util.function.Predicate;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class GeneratorConfig
extends BaseMekanismConfig {
    private static final String NAQUADAH_CATEGORY = "naquadah_reactor";
    private static final String HOHLRAUM_CATEGORY = "naquadah_hohlraum";
    private final ForgeConfigSpec configSpec;
    public final CachedFloatingLongValue energyPerReactorFuel;
    public final CachedDoubleValue reactorThermocoupleEfficiency;
    public final CachedDoubleValue reactorCasingThermalConductivity;
    public final CachedDoubleValue reactorWaterHeatingRatio;
    public final CachedLongValue reactorFuelCapacity;
    public final CachedFloatingLongValue reactorEnergyCapacity;
    public final CachedIntValue reactorWaterPerInjection;
    public final CachedLongValue reactorSteamPerInjection;
    public final CachedLongValue hohlraumMaxGas;
    public final CachedLongValue hohlraumFillRate;

    public GeneratorConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Extras(generator part) Config. This config is synced between server and client.").push("generators_extras");
        this.energyPerReactorFuel = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Affects the Injection Rate, Max Temp, and Ignition Temp.", (String)"energyPerFusionFuel", (FloatingLong)FloatingLong.createConst((long)10000000L));
        builder.pop();
        builder.comment("Reactor Settings").push(NAQUADAH_CATEGORY);
        this.reactorThermocoupleEfficiency = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The fraction of the heat dissipated from the case that is converted to Joules.").defineInRange("thermocoupleEfficiency", 0.1, 0.0, 1.0));
        this.reactorCasingThermalConductivity = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The fraction of heat from the casing that can be transferred to all sources that are not water. Will impact max heat, heat transfer to thermodynamic conductors, and power generation.").defineInRange("casingThermalConductivity", 0.1, 0.001, 1.0));
        this.reactorWaterHeatingRatio = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The fraction of the heat from the casing that is dissipated to water when water medium is in use. Will impact max heat, and polonium generation.").defineInRange("waterHeatingRatio", 0.3, 0.0, 1.0));
        this.reactorFuelCapacity = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of fuel (mB) that the naquadah reactor can store.").defineInRange("fuelCapacity", 1000L, 2L, 1000000L));
        this.reactorEnergyCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Amount of energy (J) the naquadah reactor can store.", (String)"energyCapacity", (FloatingLong)FloatingLong.createConst((long)10000000000L), (Predicate)CachedFloatingLongValue.POSITIVE);
        int baseMaxFissile = 1000000;
        this.reactorWaterPerInjection = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of water (mB) per injection rate that the naquadah reactor can store. Max = injectionRate * waterPerInjection").defineInRange("waterPerInjection", 1000000, 1, 21913098));
        this.reactorSteamPerInjection = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of polonium (mB) per injection rate that the naquadah reactor can store. Max = injectionRate * poloniumPerInjection").defineInRange("poloniumPerInjection", 100L * (long)baseMaxFissile, 1L, 94116041192395671L));
        builder.pop();
        builder.comment("Hohlraum Settings").push(HOHLRAUM_CATEGORY);
        this.hohlraumMaxGas = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Hohlraum capacity in mB.").defineInRange("maxGas", 100L, 1L, Long.MAX_VALUE));
        this.hohlraumFillRate = CachedLongValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Amount of Si-U Fuel Hohlraum can accept per tick.").defineInRange("fillRate", 1L, 1L, Long.MAX_VALUE));
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "generator_extras";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

