/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.generator_extras.client.render;

import com.jerry.generator_extras.common.content.reactor.NaquadahReactorMultiblockData;
import com.jerry.generator_extras.common.tile.reactor.TileEntityNaquadahReactorController;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.api.SupportsColorMap;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelEnergyCore;
import mekanism.client.render.tileentity.MultiblockTileEntityRenderer;
import mekanism.client.render.tileentity.RenderEnergyCube;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderNaquadahReactor
extends MultiblockTileEntityRenderer<NaquadahReactorMultiblockData, TileEntityNaquadahReactorController> {
    private static final double SCALE = 1.0E8;
    private final ModelEnergyCore core;

    public RenderNaquadahReactor(BlockEntityRendererProvider.Context context) {
        super(context);
        this.core = new ModelEnergyCore(context.m_173585_());
    }

    protected void render(TileEntityNaquadahReactorController tile, NaquadahReactorMultiblockData multiblock, float partialTicks, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        long scaledTemp = Math.round(multiblock.getLastPlasmaTemp() / 1.0E8);
        float ticks = (float)Minecraft.m_91087_().f_91060_.getTicks() + partialTicks;
        VertexConsumer buffer = renderer.m_6299_(this.core.RENDER_TYPE);
        matrix.m_85836_();
        matrix.m_85837_(0.5, -3.5, 0.5);
        float scale = 1.0f + 0.7f * RenderNaquadahReactor.sinDegrees(3.14f * (float)scaledTemp + 135.0f);
        this.renderPart(matrix, buffer, overlayLight, EnumColor.DARK_GREEN, scale, ticks, -6, -7, 0, 36);
        scale = 1.0f + 0.8f * RenderNaquadahReactor.sinDegrees(3L * scaledTemp);
        this.renderPart(matrix, buffer, overlayLight, EnumColor.YELLOW, scale, ticks, 4, 4, 0, 36);
        scale = 1.0f - 0.9f * RenderNaquadahReactor.sinDegrees(4L * scaledTemp + 90L);
        this.renderPart(matrix, buffer, overlayLight, EnumColor.WHITE, scale, ticks, 5, -3, -35, 106);
        matrix.m_85849_();
        this.endIfNeeded(renderer, this.core.RENDER_TYPE);
    }

    private static float sinDegrees(float degrees) {
        return Mth.m_14031_((float)(degrees % 360.0f * ((float)Math.PI / 180)));
    }

    protected String getProfilerSection() {
        return "naquadahReactor";
    }

    private void renderPart(PoseStack matrix, VertexConsumer buffer, int overlayLight, EnumColor color, float scale, float ticks, int mult1, int mult2, int shift1, int shift2) {
        matrix.m_85836_();
        matrix.m_85841_(2.0f * scale, 2.0f * scale, 2.0f * scale);
        matrix.m_252781_(Axis.f_252436_.m_252977_(ticks * (float)mult1 + (float)shift1));
        matrix.m_252781_(RenderEnergyCube.coreVec.m_252977_(ticks * (float)mult2 + (float)shift2));
        this.core.render(matrix, buffer, 0xF000F0, overlayLight, (SupportsColorMap)color, 1.0f);
        matrix.m_85849_();
    }

    protected boolean shouldRender(TileEntityNaquadahReactorController tile, NaquadahReactorMultiblockData multiblock, Vec3 camera) {
        return multiblock.isBurning();
    }
}

