/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Utils {
    public static List<ItemStack> mergeItemStacks(List<ItemStack> stacks) {
        int totalAmount;
        ItemStackKey key;
        HashMap<ItemStackKey, Integer> itemCounts = new HashMap<ItemStackKey, Integer>();
        ArrayList<ItemStack> mergedStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : stacks) {
            if (itemStack.m_41619_()) continue;
            key = new ItemStackKey(itemStack);
            totalAmount = itemCounts.getOrDefault(key, 0) + itemStack.m_41613_();
            itemCounts.put(key, totalAmount);
        }
        for (Map.Entry entry : itemCounts.entrySet()) {
            int stackSize;
            key = (ItemStackKey)entry.getKey();
            int maxStackSize = key.getMaxStackSize();
            for (totalAmount = ((Integer)entry.getValue()).intValue(); totalAmount > 0; totalAmount -= stackSize) {
                stackSize = Math.min(totalAmount, maxStackSize);
                ItemStack newStack = key.createStack(stackSize);
                mergedStacks.add(newStack);
            }
        }
        return mergedStacks;
    }

    public static class ItemStackKey {
        private final Item item;
        private final CompoundTag nbt;
        private final int maxStackSize;

        public ItemStackKey(ItemStack stack) {
            this.item = stack.m_41720_();
            this.nbt = stack.m_41783_() != null ? stack.m_41783_().m_6426_() : null;
            this.maxStackSize = stack.m_41741_();
        }

        public int getMaxStackSize() {
            return this.maxStackSize;
        }

        public ItemStack createStack(int count) {
            ItemStack stack = new ItemStack((ItemLike)this.item, count);
            if (this.nbt != null) {
                stack.m_41751_(this.nbt.m_6426_());
            }
            return stack;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ItemStackKey)) {
                return false;
            }
            ItemStackKey other = (ItemStackKey)obj;
            return this.item == other.item && Objects.equals(this.nbt, other.nbt);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.nbt);
        }
    }
}

