/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateAnimalSizeData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class VariantScreenSelection
extends Screen {
    private final BlockPos position;
    private final int imageWidth;
    private final int cooldownWidth;
    private final int imageHeight;
    private final List<Button> buttons = new ArrayList<Button>();
    private final int buttonAreaHeight = 106;
    private final int sliderAreaWidth = 64;
    private AnimalPenBlockInterface<?> blockEntityInterface;
    private int leftPos;
    private int topPos;
    private int bodyTopPos;
    private int sliderBarPos;
    private float currentVariantScroll;
    private boolean isScrollingVariants;
    private boolean isCooldownOpened;
    private int selectedButton = -1;
    private Button deleteButton;
    private Button applyButton;
    private Button sliderButton;
    private Button cooldownButton;
    private LivingEntity displayEntity;
    private float entityScale;
    private float entityOffset;
    private float entityRotation = -45.0f;
    private int currentXOnEntity;
    private boolean isSelectingEntity;
    private boolean isSelectingSizeBar;
    private static final Component TITLE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen");
    private static final Component APPLY = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.apply_tooltip");
    private static final Component DELETE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.delete_tooltip");
    private static final Component SELECT_TO_DELETE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.select_to_delete_tooltip");
    private static final Component COOLDOWN_OPEN = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.cooldown_open_tooltip");
    private static final Component COOLDOWN_CLOSE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.cooldown_close_tooltip");
    private static final Component SLIDER = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.slider_tooltip");
    private static final Component SLIDER_HELPER_DRAG = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.slider_tooltip_drag");
    private static final Component SLIDER_HELPER_ARROW = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.slider_tooltip_arrow");
    private static final String BUTTON_TEXT = "gui.animal_pen.variant_selection_screen.select_variant";
    private static final String SIZE_TEXT = "gui.animal_pen.variant_selection_screen.entity_size";
    private static final String FIXED_TEXT = "gui.animal_pen.variant_selection_screen.fixed_size";
    private static final ResourceLocation TEXTURE = new ResourceLocation("animal_pen", "textures/gui/animal_selection.png");
    private static final ResourceLocation COOLDOWN_TEXTURE = new ResourceLocation("animal_pen", "textures/gui/cooldown_area.png");

    public VariantScreenSelection(BlockPos position) {
        super(TITLE);
        this.position = position;
        this.imageWidth = 176;
        this.imageHeight = 136;
        this.cooldownWidth = 149;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.leftPos = this.isCooldownOpened ? (this.f_96543_ - this.imageWidth + this.cooldownWidth) / 2 : (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.buttons.clear();
        this.bodyTopPos = this.topPos + 18;
        int buttonPos = this.leftPos + 24;
        int buttonWidth = 46;
        int buttonHeight = 20;
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        BlockEntity blockEntity = this.f_96541_.f_91073_.m_7702_(this.position);
        if (!(blockEntity instanceof AnimalPenBlockInterface)) {
            return;
        }
        AnimalPenBlockInterface animalPenEntity = (AnimalPenBlockInterface)blockEntity;
        this.blockEntityInterface = animalPenEntity;
        ListTag entityList = this.blockEntityInterface.getEntityVariants();
        if (entityList == null) {
            entityList = new ListTag();
        }
        int i = 0;
        while (i < entityList.size()) {
            int y = this.bodyTopPos + i * buttonHeight;
            int index = i++;
            this.buttons.add((Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237110_((String)BUTTON_TEXT, (Object[])new Object[]{index + 1}), button -> this.handleVariantButton(button, index)).m_252794_(buttonPos, y).m_253046_(buttonWidth, buttonHeight).m_253136_()));
        }
        this.deleteButton = (Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), this::handleDeleteButton).m_252794_(this.leftPos + 157, this.topPos + 111).m_253046_(11, 14).m_253136_());
        this.applyButton = (Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), this::handleApplyButton).m_252794_(this.leftPos + 73, this.topPos + 111).m_253046_(14, 14).m_253136_());
        this.applyButton.f_93623_ = false;
        long currentValue = this.blockEntityInterface.getAnimalDisplaySize();
        long maxValue = this.blockEntityInterface.getAnimalCount();
        if (currentValue < 1L) {
            currentValue = 1L;
        }
        if (currentValue > maxValue && maxValue != 0L) {
            currentValue = maxValue;
        }
        this.sliderBarPos = this.leftPos + 89;
        Button.Builder builder = Button.m_253074_((Component)Component.m_237119_(), button -> {}).m_252794_(this.sliderBarPos, this.topPos + 112);
        Objects.requireNonNull(this);
        this.sliderButton = (Button)this.m_7787_((GuiEventListener)builder.m_253046_(Math.max(6, (int)(64L / maxValue)), 12).m_253136_());
        this.sliderButton.f_93623_ = maxValue > 1L;
        this.sliderButton.f_93624_ = this.blockEntityInterface.canGrowEntity() && maxValue > 1L;
        int initialX = this.calculateSizeBarOffset(currentValue);
        this.sliderButton.m_252865_(this.sliderBarPos + initialX);
        CompoundTag defaultAnimal = new CompoundTag();
        this.blockEntityInterface.getStoredAnimal().m_20223_(defaultAnimal);
        EntityType.m_20642_((CompoundTag)defaultAnimal, (Level)this.f_96541_.f_91073_).map(entity -> (LivingEntity)entity).ifPresent(entity -> {
            this.displayEntity = entity;
            float width = this.displayEntity.m_20205_();
            float height = this.displayEntity.m_20206_();
            float entitySize = Math.max(1.0f, Math.max(width, height));
            this.entityScale = 60.0f / entitySize * 0.8f;
            this.entityOffset = Math.max(height, entitySize) * 0.5f;
        });
        this.cooldownButton = (Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), this::handleCooldownButton).m_252794_(this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2).m_253046_(11, 18).m_253136_());
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.displayEntity != null) {
            ++this.displayEntity.f_19797_;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private int calculateSizeBarOffset(long value) {
        if (this.blockEntityInterface.getAnimalCount() <= 1L) {
            return 0;
        }
        float percentage = (float)(value - 1L) / (float)(this.blockEntityInterface.getAnimalCount() - 1L);
        return Math.round(percentage * (float)(this.sliderAreaWidth - this.sliderButton.m_5711_()));
    }

    private long calculateSizeFromPosition(int scrollX) {
        float percentage = (float)(scrollX - this.sliderBarPos) / (float)(this.sliderAreaWidth - this.sliderButton.m_5711_());
        long maxValue = this.blockEntityInterface.getAnimalCount();
        return 1 + Math.round(percentage * (float)(maxValue - 1L));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.updateButtonPositions();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int n = this.leftPos + 88 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280614_(this.f_96547_, this.f_96539_, n, this.topPos + 3 + 7 - 9 / 2, 0x404040, false);
        this.renderVariantButtons(graphics, mouseX, mouseY, partialTicks);
        this.renderOtherButtons(graphics, mouseX, mouseY);
        this.renderScrollBar(graphics, mouseX, mouseY);
        this.renderSizeBar(graphics, mouseX, mouseY, partialTicks);
        this.renderEntity(graphics, partialTicks);
        this.renderCooldown(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltips(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_280273_(GuiGraphics graphics) {
        super.m_280273_(graphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetX = this.leftPos;
        int offsetY = this.topPos;
        graphics.m_280218_(TEXTURE, offsetX, offsetY, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderVariantButtons(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280588_(10, this.bodyTopPos, this.f_96543_ - 10, this.bodyTopPos + this.buttonAreaHeight);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            button.m_88315_(graphics, mouseX, mouseY, partialTicks);
            if (i != this.selectedButton) continue;
            this.renderButtonBorder(graphics, button, -2147418368);
        }
        graphics.m_280618_();
    }

    private void renderButtonBorder(GuiGraphics graphics, Button button, int color) {
        int width = button.m_5711_();
        int height = button.m_93694_();
        graphics.m_280509_(button.m_252754_(), button.m_252907_(), button.m_252754_() + width, button.m_252907_() + 1, color);
        graphics.m_280509_(button.m_252754_(), button.m_252907_() + height - 1, button.m_252754_() + width, button.m_252907_() + height, color);
        graphics.m_280509_(button.m_252754_(), button.m_252907_(), button.m_252754_() + 1, button.m_252907_() + height, color);
        graphics.m_280509_(button.m_252754_() + width - 1, button.m_252907_(), button.m_252754_() + width, button.m_252907_() + height, color);
    }

    private void renderOtherButtons(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.deleteButton.m_252754_() + 1, this.deleteButton.m_252907_() + 1, 176 + (this.selectedButton != -1 ? 0 : 9), 39, 9, 12);
        graphics.m_280218_(TEXTURE, this.applyButton.m_252754_() + 1, this.applyButton.m_252907_() + 1, 176 + (this.selectedButton != -1 ? 0 : 12), 51, 12, 12);
    }

    private void renderScrollBar(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        int scrollThumbHeight = 15;
        int scrollPosition = this.needsScrollBars() ? this.bodyTopPos + (int)((float)(this.buttonAreaHeight - scrollThumbHeight) * this.currentVariantScroll) : this.bodyTopPos;
        graphics.m_280218_(TEXTURE, this.leftPos + 9, scrollPosition, 176 + (this.needsScrollBars() ? 0 : 12), 0, 12, scrollThumbHeight);
    }

    private void renderSizeBar(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int n;
        this.sliderButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
        MutableComponent text = this.blockEntityInterface.canGrowEntity() ? Component.m_237110_((String)SIZE_TEXT, (Object[])new Object[]{this.blockEntityInterface.getAnimalDisplaySize(), this.blockEntityInterface.getAnimalCount()}) : Component.m_237110_((String)FIXED_TEXT, (Object[])new Object[]{this.blockEntityInterface.getAnimalDisplaySize()});
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        float textWidth = this.f_96547_.m_92852_((FormattedText)text);
        Objects.requireNonNull(this);
        float scale = Math.min(1.0f, 64.0f / textWidth);
        float f = this.sliderBarPos;
        float f2 = this.topPos + 112 + 7;
        Objects.requireNonNull(this.f_96547_);
        poseStack.m_252880_(f, f2 - 9.0f * scale / 2.0f, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        if (scale < 1.0f) {
            n = 0;
        } else {
            Objects.requireNonNull(this);
            n = (int)(64.0f - textWidth) / 2;
        }
        graphics.m_280430_(this.f_96547_, (Component)text, n, 0, 0xFFFFFF);
        poseStack.m_85849_();
    }

    private void renderEntity(@NotNull GuiGraphics graphics, float partialTicks) {
        float x = this.leftPos + 73 + 48;
        float y = this.bodyTopPos + 46;
        this.displayEntity.f_20883_ = 0.0f;
        this.displayEntity.m_146922_(0.0f);
        this.displayEntity.f_20885_ = 0.0f;
        this.displayEntity.f_20886_ = 0.0f;
        LivingEntity livingEntity = this.displayEntity;
        if (livingEntity instanceof WaterAnimal) {
            WaterAnimal animal = (WaterAnimal)livingEntity;
            animal.m_20124_(Pose.SWIMMING);
            animal.m_20282_(true);
            ((EntityAccessor)animal).setWasTouchingWater(true);
            y -= 10.0f;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 50.0f);
        poseStack.m_85841_(this.entityScale, this.entityScale, this.entityScale);
        poseStack.m_252880_(0.0f, this.entityOffset, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.entityRotation));
        EntityRenderDispatcher erd = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        erd.m_114468_(false);
        erd.m_114384_((Entity)this.displayEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, (MultiBufferSource)immediate, 0xF000F0);
        erd.m_114468_(true);
        immediate.m_109911_();
        poseStack.m_85849_();
    }

    private void renderCooldown(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)COOLDOWN_TEXTURE);
        graphics.m_280218_(COOLDOWN_TEXTURE, this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2, 149 + (this.isCooldownOpened ? 0 : 11), this.cooldownButton.m_5953_((double)mouseX, (double)mouseY) ? 18 : 1, 11, 18);
        if (this.isCooldownOpened) {
            graphics.m_280218_(COOLDOWN_TEXTURE, this.leftPos - 12 - this.cooldownWidth, this.topPos, 0, 1, this.cooldownWidth, this.imageHeight + 1);
            List<Pair<ItemStack, Component>> textList = this.blockEntityInterface.getCooldownLines();
            if (!textList.isEmpty()) {
                int leftOffset = this.leftPos - this.cooldownWidth;
                Objects.requireNonNull(this.f_96547_);
                int top = this.topPos + 9;
                for (int i = 0; i < textList.size(); ++i) {
                    Pair<ItemStack, Component> cooldown = textList.get(i);
                    int y = top + i * 16;
                    graphics.m_280480_((ItemStack)cooldown.getLeft(), leftOffset, y);
                    Component component = (Component)cooldown.getRight();
                    Objects.requireNonNull(this.f_96547_);
                    graphics.m_280430_(this.f_96547_, component, leftOffset + 18, y + 9 / 2, 0xFFFFFF);
                    if (mouseX < leftOffset || mouseX > leftOffset + 16 || mouseY < y || mouseY > y + 16) continue;
                    graphics.m_280153_(this.f_96547_, (ItemStack)cooldown.getLeft(), mouseX, mouseY);
                }
            }
        }
    }

    private void renderTooltips(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.applyButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280557_(this.f_96547_, APPLY, mouseX, mouseY);
        }
        if (this.deleteButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280557_(this.f_96547_, this.selectedButton != -1 ? DELETE : SELECT_TO_DELETE, mouseX, mouseY);
        }
        if (this.sliderButton.m_5953_((double)mouseX, (double)mouseY)) {
            List<Component> list = List.of(SLIDER, Component.m_237119_(), SLIDER_HELPER_DRAG, SLIDER_HELPER_ARROW);
            graphics.m_280666_(this.f_96547_, list, mouseX, mouseY);
        }
        if (this.cooldownButton.m_5953_((double)mouseX, (double)mouseY)) {
            graphics.m_280557_(this.f_96547_, this.isCooldownOpened ? COOLDOWN_CLOSE : COOLDOWN_OPEN, mouseX, mouseY);
        }
    }

    private boolean needsScrollBars() {
        return this.buttons.size() > 5;
    }

    private void handleDeleteButton(Button button) {
        if (this.selectedButton == -1) {
            return;
        }
        this.blockEntityInterface.getEntityVariants().remove(this.selectedButton);
        NetworkManager.sendToServer((ResourceLocation)RemoveDisplayAnimalData.ID, (FriendlyByteBuf)RemoveDisplayAnimalData.encode(this.position, this.selectedButton));
        this.selectedButton = -1;
        this.applyButton.f_93623_ = false;
        this.m_7856_();
    }

    private void handleApplyButton(Button button) {
        NetworkManager.sendToServer((ResourceLocation)UpdateDisplayAnimalData.ID, (FriendlyByteBuf)UpdateDisplayAnimalData.encode(this.position, this.blockEntityInterface.getEntityVariants().m_128728_(this.selectedButton)));
        this.displayEntity.m_20258_(this.blockEntityInterface.getEntityVariants().m_128728_(this.selectedButton));
        this.selectedButton = -1;
    }

    private void handleVariantButton(Button button, int index) {
        CompoundTag tag;
        if (button.m_252907_() + button.m_93694_() < this.bodyTopPos || button.m_252907_() > this.bodyTopPos + this.buttonAreaHeight) {
            return;
        }
        if (this.selectedButton == index) {
            this.selectedButton = -1;
            this.applyButton.f_93623_ = false;
        } else {
            this.selectedButton = index;
            boolean bl = this.applyButton.f_93623_ = !this.buttons.isEmpty();
        }
        if (this.selectedButton != -1) {
            tag = (CompoundTag)this.blockEntityInterface.getEntityVariants().get(index);
        } else {
            tag = new CompoundTag();
            this.blockEntityInterface.getStoredAnimal().m_20223_(tag);
        }
        this.displayEntity.m_20258_(tag);
        this.currentXOnEntity = 0;
    }

    private void handleCooldownButton(Button button) {
        this.isCooldownOpened = !this.isCooldownOpened;
        this.m_7856_();
    }

    private boolean scrollBarClicked(double mouseX, double mouseY) {
        int scrollLeft = this.leftPos + 9;
        int scrollRight = scrollLeft + 12;
        int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
        return mouseX >= (double)scrollLeft && mouseY >= (double)this.bodyTopPos && mouseX < (double)scrollRight && mouseY < (double)scrollBottom;
    }

    private boolean entityAreaClicked(double mouseX, double mouseY) {
        int left = this.leftPos + 73;
        int top = this.bodyTopPos;
        int right = left + 96;
        int bottom = top + 92;
        return mouseX >= (double)left && mouseX < (double)right && mouseY >= (double)top && mouseY < (double)bottom;
    }

    private boolean sizeBarClicked(double mouseX, double mouseY) {
        return this.sliderButton.m_5953_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrollBarClicked(mouseX, mouseY)) {
            this.isScrollingVariants = true;
            this.m_7979_(mouseX, mouseY, button, 0.0, 0.0);
            return true;
        }
        if (this.entityAreaClicked(mouseX, mouseY)) {
            this.currentXOnEntity = (int)mouseX;
            this.isSelectingEntity = true;
            return true;
        }
        if (this.sizeBarClicked(mouseX, mouseY)) {
            this.isSelectingSizeBar = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isSelectingEntity = false;
        this.isScrollingVariants = false;
        this.isSelectingSizeBar = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!this.needsScrollBars()) {
            return false;
        }
        this.currentVariantScroll = (float)((double)this.currentVariantScroll - amount / 10.0);
        this.currentVariantScroll = Mth.m_14036_((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
        this.updateButtonPositions();
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrollingVariants && this.needsScrollBars()) {
            int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
            this.currentVariantScroll = ((float)mouseY - (float)this.bodyTopPos) / (float)(scrollBottom - this.bodyTopPos);
            this.currentVariantScroll = Mth.m_14036_((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
            return true;
        }
        if (this.isSelectingEntity) {
            int deltaX = (int)mouseX - this.currentXOnEntity;
            this.entityRotation -= (float)deltaX;
            while (this.entityRotation < 0.0f) {
                this.entityRotation += 360.0f;
            }
            while (this.entityRotation >= 360.0f) {
                this.entityRotation -= 360.0f;
            }
            this.currentXOnEntity = (int)mouseX;
            return true;
        }
        if (this.isSelectingSizeBar && this.sliderButton.m_142518_() && this.blockEntityInterface.canGrowEntity()) {
            int newX = (int)Mth.m_14008_((double)mouseX, (double)this.sliderBarPos, (double)(this.sliderBarPos + this.sliderAreaWidth - this.sliderButton.m_5711_()));
            long newValue = this.calculateSizeFromPosition(newX);
            this.blockEntityInterface.setAnimalDisplaySize(newValue);
            NetworkManager.sendToServer((ResourceLocation)UpdateAnimalSizeData.ID, (FriendlyByteBuf)UpdateAnimalSizeData.encode(this.position, newValue));
            int snapPoint = this.calculateSizeBarOffset(newValue);
            this.sliderButton.m_252865_(this.sliderBarPos + snapPoint);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 263 || keyCode == 262) && this.sliderButton.m_142518_() && this.blockEntityInterface.canGrowEntity()) {
            long currentValue = this.blockEntityInterface.getAnimalDisplaySize();
            long maxValue = this.blockEntityInterface.getAnimalCount();
            long newValue = keyCode == 263 ? Math.max(1L, currentValue - 1L) : Math.min(maxValue, currentValue + 1L);
            if (newValue != currentValue) {
                this.sliderButton.m_252865_(this.sliderBarPos + this.calculateSizeBarOffset(newValue));
                this.blockEntityInterface.setAnimalDisplaySize(newValue);
                NetworkManager.sendToServer((ResourceLocation)UpdateAnimalSizeData.ID, (FriendlyByteBuf)UpdateAnimalSizeData.encode(this.position, newValue));
                return true;
            }
        } else {
            if ((keyCode == 265 || keyCode == 264) && this.buttons.size() > 1) {
                int button = keyCode == 264 ? Math.min(this.selectedButton + 1, this.buttons.size() - 1) : Math.max(this.selectedButton - 1, 0);
                if (button != this.selectedButton) {
                    this.ensureButtonVisible(button);
                    this.handleVariantButton(this.buttons.get(button), button);
                }
                return true;
            }
            if (keyCode == 257) {
                if (this.selectedButton >= 0 && this.selectedButton < this.buttons.size() && this.applyButton.m_142518_()) {
                    this.handleApplyButton(null);
                    return true;
                }
            } else if (keyCode == 261 && this.selectedButton >= 0 && this.selectedButton < this.buttons.size()) {
                this.handleDeleteButton(null);
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private void updateButtonPositions() {
        int buttonHeight = 20;
        int totalButtonsHeight = this.buttons.size() * buttonHeight;
        int maxScrollPixels = Math.max(0, totalButtonsHeight - this.buttonAreaHeight);
        int scrollOffset = (int)((float)maxScrollPixels * this.currentVariantScroll);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            button.m_253211_(this.bodyTopPos + i * buttonHeight - scrollOffset);
        }
    }

    private void ensureButtonVisible(int buttonIndex) {
        if (buttonIndex < 0 || buttonIndex >= this.buttons.size()) {
            return;
        }
        Button targetButton = this.buttons.get(buttonIndex);
        int buttonTop = targetButton.m_252907_();
        int buttonBottom = buttonTop + targetButton.m_93694_();
        float areaDifference = this.buttons.size() * targetButton.m_93694_() - this.buttonAreaHeight;
        if (buttonTop < this.bodyTopPos) {
            float newScrollPos = (float)(this.bodyTopPos - buttonTop) / areaDifference;
            this.currentVariantScroll = Mth.m_14036_((float)(this.currentVariantScroll - newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        } else if (buttonBottom > this.bodyTopPos + this.buttonAreaHeight) {
            float newScrollPos = (float)(buttonBottom - this.bodyTopPos - 106) / areaDifference;
            this.currentVariantScroll = Mth.m_14036_((float)(this.currentVariantScroll + newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        }
    }
}

