/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jei;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.compat.jei.BreweryCategory;
import de.melanx.utilitix.compat.jei.GildingCategory;
import de.melanx.utilitix.compat.jei.RecipeTypes;
import de.melanx.utilitix.content.brewery.ScreenAdvancedBrewery;
import de.melanx.utilitix.content.gildingarmor.GildingArmorRecipe;
import de.melanx.utilitix.recipe.EffectTransformer;
import de.melanx.utilitix.registration.ModBlocks;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRecipeTypes;
import de.melanx.utilitix.registration.ModRegisterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

@JeiPlugin
public class UtiliJei
implements IModPlugin {
    private static IJeiRuntime runtime = null;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation(UtilitiX.getInstance().modid, "jeiplugin");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BreweryCategory(registration.getJeiHelpers().getGuiHelper()), new GildingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeManager recipes = Objects.requireNonNull(level).m_7465_();
        List simpleBrewery = recipes.m_44013_(ModRecipeTypes.BREWERY).stream().filter(r -> r.getAction() instanceof EffectTransformer.Apply).collect(Collectors.toList());
        registration.addRecipes(RecipeTypes.BREWING, simpleBrewery);
        registration.addRecipes(RecipeTypes.GILDING, UtiliJei.getGildingRecipes());
        registration.addIngredientInfo((Object)new ItemStack(ModBlocks.advancedBrewery), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.advanced_brewery"), Component.m_237115_((String)"description.utilitix.advanced_brewery.brewing"), Component.m_237115_((String)"description.utilitix.advanced_brewery.merging"), Component.m_237115_((String)"description.utilitix.advanced_brewery.upgrading"), Component.m_237115_((String)"description.utilitix.advanced_brewery.cloning")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.comparatorRedirectorUp), (Object)new ItemStack((ItemLike)ModBlocks.comparatorRedirectorDown)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.comparator_redirector")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.weakRedstoneTorch), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.weak_redstone_torch")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModItems.tinyCoal), (Object)new ItemStack((ItemLike)ModItems.tinyCharcoal)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.tiny_coal")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.handBell), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.hand_bell")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.mobBell), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.mob_bell")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.failedPotion), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.failed_potion")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.armedStand), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.armed_stand")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.glueBall), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.glue_ball")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.linkedCrystal), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.linked_crystal")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.linkedRepeater), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.linked_repeater")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.minecartTinkerer), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.minecart_tinkerer")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.highspeedRail), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.highspeed_rail")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.directionalRail), (Object)new ItemStack((ItemLike)ModBlocks.directionalHighspeedRail)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.directional_rail")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.crossingRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedCrossingRail)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.crossing_rail")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.filterRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedFilterRail)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.filter_rail")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.reinforcedRail), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.reinforced_rail")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegisterables.enderCart.item()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.ender_cart")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegisterables.pistonCart.item()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.piston_cart")});
        registration.addIngredientInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.pistonControllerRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedPistonControllerRail)), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.piston_controller_rail")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegisterables.stonecutterCart.item()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.stonecutter_cart")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModRegisterables.anvilCart.item()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.anvil_cart")});
        registration.addIngredientInfo((Object)new ItemStack(ModBlocks.crudeFurnace), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"description.utilitix.crude_furnace")});
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.advancedBrewery), new RecipeType[]{RecipeTypes.BREWING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50625_), new RecipeType[]{RecipeTypes.GILDING});
    }

    public void registerGuiHandlers(@Nonnull IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ScreenAdvancedBrewery.class, 98, 17, 7, 26, new RecipeType[]{RecipeTypes.BREWING});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public static void runtime(Consumer<IJeiRuntime> action) {
        if (runtime != null) {
            action.accept(runtime);
        }
    }

    public static <T> Optional<T> runtime(Function<IJeiRuntime, T> action) {
        if (runtime != null) {
            return Optional.of(action.apply(runtime));
        }
        return Optional.empty();
    }

    private static List<SmithingTransformRecipe> getGildingRecipes() {
        ArrayList recipes = Lists.newArrayList();
        Ingredient gildingItem = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.gildingCrystal});
        for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
            ArmorItem item;
            Object v = entry.getValue();
            if (!(v instanceof ArmorItem) || !GildingArmorRecipe.canGild(item = (ArmorItem)v, new ItemStack((ItemLike)item))) continue;
            ResourceLocation id = UtilitiX.getInstance().resource("gilding/" + ((ResourceKey)entry.getKey()).m_135782_().m_135827_() + "/" + ((ResourceKey)entry.getKey()).m_135782_().m_135815_());
            ItemStack output = new ItemStack((ItemLike)item);
            output.m_41784_().m_128379_("Gilded_UtilitiX", true);
            SmithingTransformRecipe recipe = new SmithingTransformRecipe(id, Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), gildingItem, output);
            recipes.add(recipe);
        }
        return Collections.unmodifiableList(recipes);
    }
}

