/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.BotaniaConfig;

public class MunchdewBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_ATE_ONCE = "ateOnce";
    private static final int RANGE = 8;
    private static final int RANGE_Y = 16;
    private boolean ateOnce = false;
    private int ticksWithoutEating = -1;
    private int cooldown = 0;

    public MunchdewBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.MUNCHDEW, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            this.ticksWithoutEating = 0;
            this.ateOnce = false;
            return;
        }
        int manaPerLeaf = 160;
        if (this.getMaxMana() - this.getMana() >= manaPerLeaf && this.ticksExisted % 4 == 0) {
            HashMap<BlockPos, Float> coordsMap = new HashMap<BlockPos, Float>();
            Random rng = new Random();
            BlockPos pos = this.getEffectivePos();
            block0: for (Object pos_ : BlockPos.m_121940_((BlockPos)pos.m_7918_(-8, 0, -8), (BlockPos)pos.m_7918_(8, 16, 8))) {
                BlockState state = this.m_58904_().m_8055_((BlockPos)pos_);
                if (!state.m_204336_(BlockTags.f_13035_)) continue;
                for (Direction dir : Direction.values()) {
                    if (!this.m_58904_().m_46859_(pos_.m_121945_(dir))) continue;
                    coordsMap.put(pos_.m_7949_(), Float.valueOf((float)(state.m_61138_((Property)LeavesBlock.f_54418_) ? (Integer)state.m_61143_((Property)LeavesBlock.f_54418_) : 1) + 2.0f * rng.nextFloat()));
                    continue block0;
                }
            }
            if (!coordsMap.isEmpty()) {
                Object pos_;
                float maxDistance = 0.0f;
                pos_ = coordsMap.values().iterator();
                while (pos_.hasNext()) {
                    float distance = ((Float)pos_.next()).floatValue();
                    maxDistance = Math.max(maxDistance, distance);
                }
                float finalMaxDistance = maxDistance;
                coordsMap.values().removeIf(dist -> dist.floatValue() < finalMaxDistance - 1.0f);
                ArrayList coords = new ArrayList(coordsMap.keySet());
                BlockPos breakCoords = (BlockPos)coords.get(this.f_58857_.m_213780_().m_188503_(coords.size()));
                BlockState state = this.m_58904_().m_8055_(breakCoords);
                this.m_58904_().m_7471_(breakCoords, false);
                this.ticksWithoutEating = 0;
                this.ateOnce = true;
                if (BotaniaConfig.common().blockBreakParticles()) {
                    this.m_58904_().m_46796_(2001, breakCoords, Block.m_49956_((BlockState)state));
                }
                this.m_58904_().m_142346_(null, GameEvent.f_157794_, breakCoords);
                this.addMana(manaPerLeaf);
            }
        }
        if (this.ateOnce) {
            ++this.ticksWithoutEating;
            if (this.ticksWithoutEating >= 5) {
                this.cooldown = 1600;
                this.sync();
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 8);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.cooldown);
        cmp.m_128379_(TAG_ATE_ONCE, this.ateOnce);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.m_128451_(TAG_COOLDOWN);
        this.ateOnce = cmp.m_128471_(TAG_ATE_ONCE);
    }

    @Override
    public int getColor() {
        return 7980079;
    }

    @Override
    public int getMaxMana() {
        return 10000;
    }
}

