/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.ice;

import com.gametechbc.iasspellbooks.api.spells.AbstractUniqueSpell;
import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class IceCreamSandwichSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "ice_cream_sandwich");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(2).setCooldownSeconds(300.0).build();

    public IceCreamSandwichSpell() {
        this.manaCostPerLevel = 75;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 10;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11868_);
    }

    public void onCast(Level world, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        int numberOfEntities = 8;
        double radius = 2.5;
        double throwForce = 1.5;
        for (int i = 0; i < numberOfEntities; ++i) {
            double angle = Math.PI * 2 / (double)numberOfEntities * (double)i;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            TrickOrTreatEntity trickOrTreatEntity = new TrickOrTreatEntity((EntityType)ModEntityTypes.TrickOrTreat.get(), world);
            trickOrTreatEntity.circleTime = i * 20;
            trickOrTreatEntity.bounceTime = i;
            trickOrTreatEntity.m_6034_(caster.m_20185_() + offsetX, caster.m_20186_() + 1.0, caster.m_20189_() + offsetZ);
            Vec3 throwDirection = new Vec3(offsetX, 0.0, offsetZ).m_82541_().m_82490_(throwForce);
            trickOrTreatEntity.m_20256_(throwDirection);
            trickOrTreatEntity.setOwner(caster);
            trickOrTreatEntity.setTreat(caster.m_217043_().m_188503_(6) + 1);
            if (caster.m_5647_() != null) {
                world.m_6188_().m_6546_(trickOrTreatEntity.m_20149_(), world.m_6188_().m_83489_(caster.m_5647_().m_5758_()));
            }
            this.circleTreat((Entity)trickOrTreatEntity, i, numberOfEntities);
            world.m_7967_((Entity)trickOrTreatEntity);
        }
        super.onCast(world, spellLevel, caster, castSource, playerMagicData);
    }

    private void circleTreat(Entity entity, int number, int amount) {
        float yaw = (float)number * ((float)Math.PI * 2 / (float)amount);
        float vy = 0.3f;
        float vx = 0.5f * Mth.m_14089_((float)yaw);
        float vz = 0.5f * Mth.m_14031_((float)yaw);
        entity.m_20334_((double)vx, (double)vy, (double)vz);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

