/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.fire;

import com.gametechbc.iasspellbooks.api.particle.ParticleDirection;
import com.gametechbc.iasspellbooks.api.particle.SphereParticleManager;
import com.gametechbc.iasspellbooks.api.spells.IASSSpellAnimations;
import com.yellowbrossproductions.illageandspillage.entities.ImpEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

@AutoSpellConfig
public class BlazingImprintSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "blazing_imprint");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(6).setCooldownSeconds(8.0).build();

    public BlazingImprintSpell() {
        this.manaCostPerLevel = 40;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 5;
        this.baseManaCost = 40;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return IASSSpellAnimations.NULLFLARE_FINISH;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        int impCount = this.getImpCount(spellLevel);
        double casterX = caster.m_20185_();
        double casterZ = caster.m_20189_();
        double casterHeadY = caster.m_20186_() + 1.0;
        int standOnYPos = Mth.m_14107_((double)caster.m_20186_()) - 2;
        float yawRadians = (float)Math.toRadians(90.0f + caster.m_146908_());
        for (int i = 0; i < impCount; ++i) {
            double distance = 2.25 * (double)(i + 1);
            int waitTime = 1 + (int)(1.5f * (float)i);
            double spawnX = casterX + (double)Mth.m_14089_((float)yawRadians) * distance;
            double spawnZ = casterZ + (double)Mth.m_14031_((float)yawRadians) * distance;
            this.spawnImpEntity(spawnX, spawnZ, standOnYPos, casterHeadY, waitTime, level, caster, spellLevel);
        }
        SphereParticleManager.spawnParticles(level, caster, 50, (ParticleOptions)ParticleTypes.f_123744_, ParticleDirection.OUTWARD, 3.0);
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    private void spawnImpEntity(double x, double z, double minY, double maxY, int waitTime, Level level, LivingEntity caster, int spellLevel) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean isPositionValid = false;
        double posY = 0.0;
        int impPower = this.getImpPower(spellLevel, caster);
        do {
            BlockState posState;
            VoxelShape shape;
            BlockPos belowPos;
            BlockState blockState;
            if (!(blockState = level.m_8055_(belowPos = pos.m_7495_())).m_60783_((BlockGetter)level, belowPos, Direction.UP)) continue;
            if (!level.m_46859_(pos) && !(shape = (posState = level.m_8055_(pos)).m_60812_((BlockGetter)level, pos)).m_83281_()) {
                posY = shape.m_83297_(Direction.Axis.Y);
            }
            isPositionValid = true;
            break;
        } while ((pos = pos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (isPositionValid) {
            ImpEntity impEntity = new ImpEntity((EntityType)ModEntityTypes.Imp.get(), level);
            impEntity.m_6034_(x, (double)pos.m_123342_() + posY, z);
            impEntity.setOwner(caster);
            impEntity.setPower(impPower);
            impEntity.setWaitTime(waitTime);
            level.m_7967_((Entity)impEntity);
        }
    }

    private int getImpCount(int spellLevel) {
        return 4 + spellLevel * 2;
    }

    private int getImpPower(int spellLevel, LivingEntity caster) {
        return (int)(6.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.imp_count", (Object[])new Object[]{this.getImpCount(spellLevel)}), Component.m_237110_((String)"ui.ias_spellbooks.damage", (Object[])new Object[]{this.getImpPower(spellLevel, caster) + 4}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

