/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.evocation;

import com.gametechbc.iasspellbooks.api.particle.CylinderParticleManager;
import com.gametechbc.iasspellbooks.api.particle.ParticleDirection;
import com.gametechbc.iasspellbooks.api.spells.AbstractUniqueSpell;
import com.gametechbc.iasspellbooks.api.spells.IASSSpellAnimations;
import com.yellowbrossproductions.illageandspillage.entities.projectile.DarkPotionEntity;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class RestorativeRainSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "restorative_rain");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(3).setCooldownSeconds(60.0).build();

    public RestorativeRainSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 60;
        this.baseManaCost = 14;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_POTIONS.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return IASSSpellAnimations.RESTORATIVE_RAIN_LOOP;
    }

    public void onCast(Level world, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        super.onCast(world, spellLevel, caster, castSource, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity caster, @Nullable MagicData playerMagicData) {
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 2 == 0) {
            int darkPotionCount = this.getPotionCount(spellLevel, caster);
            for (int i = 0; i < darkPotionCount; ++i) {
                double offsetX = (Math.random() - 0.5) * 0.1;
                double offsetZ = (Math.random() - 0.5) * 0.1;
                Vec3 upwardDirection = new Vec3(offsetX, 1.0, offsetZ).m_82541_().m_82490_(1.5);
                DarkPotionEntity splashPotion = new DarkPotionEntity(EntityType.f_20486_, level);
                splashPotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)ItemRegisterer.DARK_SPLASH.get()), (Potion)Potions.f_43623_));
                splashPotion.m_6034_(caster.m_20185_(), caster.m_20186_() + 1.0, caster.m_20189_());
                splashPotion.m_20256_(upwardDirection);
                splashPotion.m_5602_((Entity)caster);
                level.m_7967_((Entity)splashPotion);
            }
            CylinderParticleManager.spawnParticles(level, caster, 1, (ParticleOptions)ParticleTypes.f_123766_, ParticleDirection.UPWARD, 1.0, 2.0, 0.0);
        }
    }

    private int getPotionCount(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 1.5f);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.potion_count", (Object[])new Object[]{Utils.stringTruncation((double)this.getPotionCount(spellLevel, caster), (int)0)}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

