/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.evocation;

import com.gametechbc.iasspellbooks.api.spells.AbstractUniqueSpell;
import com.yellowbrossproductions.illageandspillage.entities.IllagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class HellishHordeSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "hellish_horde");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(2).setCooldownSeconds(300.0).build();

    public HellishHordeSpell() {
        this.manaCostPerLevel = 75;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 10;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11868_);
    }

    public void onCast(Level world, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        int numberOfEntities = this.getIllagerSoulCount(spellLevel, caster);
        double radius = 3.0;
        double throwForce = 0.5;
        List nearbyEntities = world.m_6443_(LivingEntity.class, caster.m_20191_().m_82400_(10.0), e -> e != caster);
        for (int i = 0; i < numberOfEntities; ++i) {
            double angle = Math.PI * 2 / (double)numberOfEntities * (double)i;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            IllagerSoulEntity illagerSoul = new IllagerSoulEntity((EntityType)ModEntityTypes.IllagerSoul.get(), world);
            illagerSoul.setOwner(caster);
            illagerSoul.m_6034_(caster.m_20185_() + offsetX, caster.m_20186_() + 6.0, caster.m_20189_() + offsetZ);
            if (!nearbyEntities.isEmpty()) {
                LivingEntity target = (LivingEntity)nearbyEntities.get(world.f_46441_.m_188503_(nearbyEntities.size()));
                illagerSoul.m_6710_(target);
            }
            Vec3 throwDirection = new Vec3(offsetX, 0.0, offsetZ).m_82541_().m_82490_(throwForce);
            illagerSoul.m_20256_(throwDirection);
            if (caster.m_5647_() != null) {
                world.m_6188_().m_6546_(illagerSoul.m_20149_(), world.m_6188_().m_83489_(caster.m_5647_().m_5758_()));
            }
            illagerSoul.setAngelOrDevil(world.f_46441_.m_188499_());
            world.m_7967_((Entity)illagerSoul);
        }
        super.onCast(world, spellLevel, caster, castSource, playerMagicData);
    }

    private int getIllagerSoulCount(int spellLevel, LivingEntity caster) {
        return (int)(this.getSpellPower(spellLevel, (Entity)caster) * 2.0f);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.illager_soul_count", (Object[])new Object[]{this.getIllagerSoulCount(spellLevel, caster)}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

