/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.evocation;

import com.gametechbc.iasspellbooks.api.spells.AbstractUniqueSpell;
import com.gametechbc.iasspellbooks.entity.summons.SummonedSpiritHand;
import com.gametechbc.iasspellbooks.init.IASSEffects;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

@AutoSpellConfig
public class EtherealGraspSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "ethereal_grasp");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(2).setCooldownSeconds(300.0).build();

    public EtherealGraspSpell() {
        this.manaCostPerLevel = 75;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11868_);
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 12000;
        int koboletonCount = 2;
        double radius = 5.0;
        double angleIncrement = Math.PI * 2 / (double)koboletonCount;
        for (int i = 0; i < koboletonCount; ++i) {
            double angle = (double)i * angleIncrement;
            double xOffset = radius * Math.cos(angle);
            double zOffset = radius * Math.sin(angle);
            SummonedSpiritHand spiritHand = new SummonedSpiritHand(world, entity);
            spiritHand.m_6034_(entity.m_20185_() + xOffset, entity.m_20186_(), entity.m_20189_() + zOffset);
            spiritHand.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getHandDamage(spellLevel, entity));
            spiritHand.m_21153_(spiritHand.m_21233_());
            spiritHand.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(spiritHand.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
            spiritHand.setGoodOrEvil(world.f_46441_.m_188499_());
            world.m_7967_((Entity)spiritHand);
            spiritHand.m_7292_(new MobEffectInstance((MobEffect)IASSEffects.SPIRIT_HAND_TIMER.get(), summonTime, 0, false, false, false));
        }
        int effectAmplifier = 0;
        if (entity.m_21023_((MobEffect)IASSEffects.SPIRIT_HAND_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)IASSEffects.SPIRIT_HAND_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)IASSEffects.SPIRIT_HAND_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getHandDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = 6.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getHandDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = 6.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.damage", (Object[])new Object[]{this.getHandDamageText(spellLevel, caster)}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

