/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.eldritch;

import com.gametechbc.iasspellbooks.api.particle.CylinderParticleManager;
import com.gametechbc.iasspellbooks.api.particle.ParticleDirection;
import com.gametechbc.iasspellbooks.api.spells.AbstractUniqueSpell;
import com.gametechbc.iasspellbooks.entity.summons.SummonedRagno;
import com.gametechbc.iasspellbooks.init.IASSEffects;
import com.yellowbrossproductions.illageandspillage.particle.ParticleRegisterer;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

@AutoSpellConfig
public class VenomousRebornSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "venomous_reborn");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(2).setCooldownSeconds(300.0).build();

    public VenomousRebornSpell() {
        this.manaCostPerLevel = 250;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 90;
        this.baseManaCost = 300;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SCREECH.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SPAWN.get());
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        CylinderParticleManager.spawnParticles(level, entity, 1, (ParticleOptions)ParticleRegisterer.MUTATION_PARTICLES.get(), ParticleDirection.UPWARD, 2.0, 2.0, 0.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 12000;
        double offset = 3.0;
        double angle = Math.toRadians(-entity.m_146908_());
        double xOffset = offset * Math.cos(angle);
        double zOffset = offset * Math.sin(angle);
        SummonedRagno ragno = new SummonedRagno(world, entity);
        ragno.m_6034_(entity.m_20185_() + xOffset, entity.m_20186_(), entity.m_20189_() + zOffset);
        ragno.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getRagnoDamage(spellLevel, entity));
        ragno.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getRagnoHealth(spellLevel));
        ragno.m_21153_(ragno.m_21233_());
        ragno.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(ragno.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
        world.m_7967_((Entity)ragno);
        ragno.m_7292_(new MobEffectInstance((MobEffect)IASSEffects.RAGNO_TIMER.get(), summonTime, 0, false, false, false));
        int effectAmplifier = 0;
        if (entity.m_21023_((MobEffect)IASSEffects.RAGNO_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)IASSEffects.RAGNO_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)IASSEffects.RAGNO_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getRagnoHealth(int spellLevel) {
        return 70.0f + (float)spellLevel * 55.0f;
    }

    private float getRagnoDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = 6.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getRagnoDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = 4.0f + this.getSpellPower(spellLevel, (Entity)caster) * 2.0f;
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.hp", (Object[])new Object[]{Float.valueOf(this.getRagnoHealth(spellLevel))}), Component.m_237110_((String)"ui.ias_spellbooks.damage", (Object[])new Object[]{this.getRagnoDamageText(spellLevel, caster)}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

