/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.spells.blood;

import com.gametechbc.iasspellbooks.api.spells.AbstractUniqueSpell;
import com.gametechbc.iasspellbooks.entity.summons.SummonedMobSpirit;
import com.gametechbc.iasspellbooks.init.IASSEffects;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

@AutoSpellConfig
public class SpiritsChosenSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("ias_spellbooks", "spirits_chosen");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(5).setCooldownSeconds(300.0).build();

    public SpiritsChosenSpell() {
        this.manaCostPerLevel = 75;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 60;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11868_);
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTime = 12000;
        int summonLimit = this.getSummonCount(spellLevel);
        double healthAbsorb = this.getMobSpiritHealthAbsorb(spellLevel, entity);
        List nearbyEntities = world.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(12.0), e -> e != entity);
        int numberOfSummons = Math.min(nearbyEntities.size(), summonLimit);
        for (int i = 0; i < numberOfSummons; ++i) {
            LivingEntity targetEntity = (LivingEntity)nearbyEntities.get(i);
            double targetX = targetEntity.m_20185_();
            double targetY = targetEntity.m_20186_();
            double targetZ = targetEntity.m_20189_();
            float entityHeight = targetEntity.m_6972_((Pose)targetEntity.m_20089_()).f_20378_;
            double yOffset = (double)entityHeight + 2.5;
            SummonedMobSpirit mobSpirit = new SummonedMobSpirit(world, entity);
            mobSpirit.m_6034_(targetX, targetY + yOffset, targetZ);
            double baseHealth = 50.0;
            double targetHealth = targetEntity.m_21223_();
            double finalHealth = baseHealth + targetHealth * healthAbsorb;
            mobSpirit.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getMobSpiritDamage(spellLevel, entity));
            mobSpirit.m_21204_().m_22146_(Attributes.f_22276_).m_22100_(finalHealth);
            mobSpirit.m_21153_((float)finalHealth);
            mobSpirit.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(mobSpirit.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
            world.m_7967_((Entity)mobSpirit);
            mobSpirit.m_7292_(new MobEffectInstance((MobEffect)IASSEffects.MOB_SPIRIT_TIMER.get(), summonTime, 0, false, false, false));
            int effectAmplifier = 0;
            if (entity.m_21023_((MobEffect)IASSEffects.MOB_SPIRIT_TIMER.get())) {
                effectAmplifier += entity.m_21124_((MobEffect)IASSEffects.MOB_SPIRIT_TIMER.get()).m_19564_() + 1;
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)IASSEffects.MOB_SPIRIT_TIMER.get(), summonTime, effectAmplifier, false, false, true));
            double damageToApply = targetHealth * healthAbsorb;
            DamageSources.applyDamage((Entity)targetEntity, (float)((float)damageToApply), (DamageSource)this.getDamageSource((Entity)entity));
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private int getSummonCount(int spellLevel) {
        return spellLevel;
    }

    private float getMobSpiritHealthAbsorb(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.025f;
    }

    private float getMobSpiritDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = 2.5f + this.getSpellPower(spellLevel, (Entity)caster) * 1.5f;
        double summonedDamageMultiplier = 1.0;
        if (caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get())) {
            summonedDamageMultiplier = caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get());
        }
        return (float)((double)baseDamage * summonedDamageMultiplier);
    }

    private String getMobSpiritDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = 3.5f + this.getSpellPower(spellLevel, (Entity)caster) * 1.5f;
            double summonedDamageMultiplier = caster.m_21204_().m_22171_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) ? caster.m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()) : 1.0;
            float finalDamage = (float)((double)baseDamage * summonedDamageMultiplier);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (summonedDamageMultiplier > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return "" + this.getSpellPower(spellLevel, (Entity)caster);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.ias_spellbooks.summon_limit", (Object[])new Object[]{this.getSummonCount(spellLevel)}), Component.m_237110_((String)"ui.ias_spellbooks.damage", (Object[])new Object[]{this.getMobSpiritDamageText(spellLevel, caster)}), Component.m_237110_((String)"ui.ias_spellbooks.hp_absorb", (Object[])new Object[]{Float.valueOf(this.getMobSpiritHealthAbsorb(spellLevel, caster))}), Component.m_237113_((String)"\u00a79Illage and Spell-age"));
    }
}

