/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.iasspellbooks.entity.summons;

import com.gametechbc.iasspellbooks.init.IASSEffects;
import com.gametechbc.iasspellbooks.init.IASSEntities;
import com.gametechbc.iasspellbooks.init.IASSSpells;
import com.yellowbrossproductions.illageandspillage.entities.MobSpiritEntity;
import com.yellowbrossproductions.illageandspillage.particle.ParticleRegisterer;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SummonedMobSpirit
extends MobSpiritEntity
implements MagicSummon {
    protected LivingEntity cachedSummoner;
    protected UUID summonerUUID;
    private float riddenSpeed;

    public SummonedMobSpirit(EntityType<? extends MobSpiritEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 0;
        this.riddenSpeed = 1.0f;
    }

    public SummonedMobSpirit(Level level, LivingEntity owner) {
        this((EntityType<? extends MobSpiritEntity>)((EntityType)IASSEntities.SUMMONED_MOB_SPIRIT.get()), level);
        this.setSummoner(owner);
    }

    public void m_8099_() {
        this.f_21345_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof HurtByTargetGoal || goal.m_26015_() instanceof NearestAttackableTargetGoal);
        this.f_21346_.m_25352_(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.f_21346_.m_25352_(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        this.f_21345_.m_25352_(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)0.9f, 15.0f, 5.0f, false, 25.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        super.m_8099_();
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.m_9236_(), (LivingEntity)this.cachedSummoner, (UUID)this.summonerUUID);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.m_6667_(pDamageSource);
    }

    public void onRemovedFromWorld() {
        this.onRemovedHelper((Entity)this, (SummonTimer)IASSEffects.MOB_SPIRIT_TIMER.get());
        super.onRemovedFromWorld();
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.summonerUUID = OwnerHelper.deserializeOwner((CompoundTag)compoundTag);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        OwnerHelper.serializeOwner((CompoundTag)compoundTag, (UUID)this.summonerUUID);
    }

    public boolean m_7327_(Entity pEntity) {
        return Utils.doMeleeAttack((Mob)this, (Entity)pEntity, (DamageSource)((AbstractSpell)IASSSpells.VENOMOUS_REBORN_SPELL.get()).getDamageSource((Entity)this, (Entity)this.getSummoner()));
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || this.isAlliedHelper(pEntity);
    }

    public void onUnSummon() {
        if (!this.m_9236_().f_46443_) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)((ParticleOptions)ParticleRegisterer.MUTATION_PARTICLES.get()), (double)this.m_20185_(), (double)(this.m_20186_() + 2.0), (double)this.m_20189_(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268738_) && this.shouldIgnoreDamage(pSource)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected boolean m_8028_() {
        return false;
    }
}

