/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils.radio;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.utils.GsonHelpers;
import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.common.utils.radio.StationInfo;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class StationLoader {
    private static final Codec<List<StationInfo>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StationInfo.CODEC.listOf().fieldOf("stations").forGetter(Function.identity())).apply((Applicative)instance, Function.identity()));
    private static final List<StationInfo> STATIONS = new ArrayList<StationInfo>();

    public static void init() {
        JsonObject object = StationLoader.readLocalStations();
        if (object == null) {
            object = WebUtils.getJson((String)"https://adastra.terrarium.earth/stations");
        }
        if (object == null) {
            return;
        }
        STATIONS.clear();
        CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).result().ifPresent(STATIONS::addAll);
    }

    public static List<StationInfo> stations() {
        return STATIONS;
    }

    public static boolean hasStation(String url) {
        return STATIONS.stream().anyMatch(station -> station.url().equals(url));
    }

    @Nullable
    private static JsonObject readLocalStations() {
        String stationsFile = System.getProperty("adastra.stations");
        if (stationsFile != null) {
            String fileName = stationsFile.indexOf(47) == -1 ? stationsFile : stationsFile.substring(stationsFile.lastIndexOf(47) + 1);
            try {
                AdAstra.LOGGER.info("Loading stations from {}", (Object)fileName);
                return GsonHelpers.parseJson((String)Files.readString(Path.of(stationsFile, new String[0]))).orElse(null);
            }
            catch (Exception exception) {
                AdAstra.LOGGER.error("Failed loading stations from {}", (Object)fileName, (Object)exception);
                return null;
            }
        }
        return null;
    }
}

