/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.common.entities.vehicles.Vehicle;
import earth.terrarium.adastra.common.menus.vehicles.RoverMenu;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ClientboundPlayStationPacket;
import earth.terrarium.adastra.common.registry.ModDamageSources;
import earth.terrarium.adastra.common.registry.ModItems;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.radio.RadioHolder;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class Rover
extends Vehicle
implements PlayerRideable,
RadioHolder {
    private static final float MAX_SPEED_KM = 50.0f;
    private static final float ACCELERATION_RATE = 0.02f;
    public static final EntityDataAccessor<Long> FUEL = SynchedEntityData.m_135353_(Rover.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.m_135353_(Rover.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final SimpleFluidContainer fluidContainer = new SimpleFluidContainer(FluidConstants.fromMillibuckets((long)3000L), 1, (amount, fluid) -> fluid.is(ModFluidTags.TIER_1_ROVER_FUEL));
    private float speed;
    private float angle;
    public float wheelXRot;
    public float wheelYRot;
    private String radioUrl = "";

    public Rover(EntityType<?> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.addPart(0.6f, 0.7f, new Vector3f(0.6f, 1.0f, 0.5f), (player, hand) -> {
            if (player.m_20202_() instanceof Rover) {
                if (player.m_9236_().m_5776_()) {
                    RadioHandler.open(null);
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
            }
            return InteractionResult.PASS;
        });
        this.addPart(1.1f, 0.7f, new Vector3f(0.15f, 0.8f, -1.7f), (player, hand) -> {
            if (!this.m_9236_().m_5776_()) {
                this.m_213583_((Player)player);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        });
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUEL, (Object)0L);
        this.f_19804_.m_135372_(FUEL_TYPE, (Object)"air");
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.speed = compound.m_128457_("Speed");
        this.angle = compound.m_128457_("Angle");
        this.fluidContainer.deserialize(compound);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Speed", this.speed);
        compound.m_128350_("Angle", this.angle);
        this.fluidContainer.serialize(compound);
    }

    public FluidContainer fluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public ItemStack getDropStack() {
        ItemStackHolder stack = new ItemStackHolder(((Item)ModItems.ROVER.get()).m_7968_());
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)stack);
        if (container == null) {
            return stack.getStack();
        }
        FluidApi.moveFluid((FluidContainer)this.fluidContainer, (FluidContainer)container, (FluidHolder)this.fluidContainer.getFirstFluid(), (boolean)false);
        return stack.getStack();
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < 2;
    }

    private void clampRotation(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float degrees = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float lookAngle = Mth.m_14036_((float)degrees, (float)-105.0f, (float)105.0f);
        entityToUpdate.f_19859_ += lookAngle - degrees;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + lookAngle - degrees);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    public void m_7340_(Entity entityToUpdate) {
        this.clampRotation(entityToUpdate);
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        float zOffset = this.m_6688_() == passenger ? 1.75f : -1.75f;
        Vec3 position = new Vec3(-0.5, 0.0, (double)zOffset).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        if (this.m_9236_().m_5776_()) {
            RadioHandler.stop();
        }
        return new Vec3(this.m_20185_() + position.f_82479_, this.m_20186_(), this.m_20189_() + position.f_82481_);
    }

    @Override
    public boolean isSafeToDismount(Player player) {
        return this.speed() < 0.1f;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        float zOffset = this.m_6688_() == passenger ? -0.6f : 0.4f;
        float yOffset = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
        Vec3 position = new Vec3(-0.5, 0.0, (double)zOffset).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        this.clampRotation(passenger);
        passenger.m_146922_(passenger.m_146908_() + this.angle);
        passenger.m_5616_(passenger.m_6080_() + this.angle);
        callback.m_20372_(passenger, this.m_20185_() + position.f_82479_, this.m_20186_() + (double)yOffset, this.m_20189_() + position.f_82481_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.handleVehicleMovementTick();
        this.doEntityCollisionTick();
        if (!this.m_9236_().m_5776_()) {
            FluidUtils.moveItemToContainer((Container)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidUtils.moveContainerToItem((Container)this.inventory, (FluidContainer)this.fluidContainer, 0, 1, 0);
            FluidHolder fluidHolder = this.fluidContainer.getFirstFluid();
            this.f_19804_.m_135381_(FUEL, (Object)fluidHolder.getFluidAmount());
            this.f_19804_.m_135381_(FUEL_TYPE, (Object)BuiltInRegistries.f_257020_.m_7981_((Object)fluidHolder.getFluid()).toString());
        }
    }

    private void handleVehicleMovementTick() {
        boolean noPassenger = this.m_6688_() == null;
        float xxa = -this.xxa();
        float zza = this.zza();
        if (!this.m_20096_()) {
            xxa *= 0.2f;
            zza *= 0.2f;
        }
        if (!this.hasEnoughFuel()) {
            xxa = 0.0f;
            zza = 0.0f;
        }
        this.speed = zza != 0.0f ? (this.speed += 0.02f * zza) : (this.speed *= noPassenger ? 0.98f : 0.96f);
        if (noPassenger && this.speed < 0.1f && this.speed > -0.1f) {
            this.speed *= 0.9f;
        }
        float maxBlocksPerTick = 0.6944445f;
        this.speed = Mth.m_14036_((float)this.speed, (float)(-maxBlocksPerTick / 2.0f), (float)maxBlocksPerTick);
        this.angle = xxa != 0.0f && (this.speed > 0.05f || this.speed < -0.05f) ? (this.angle += xxa * Math.signum(this.speed) * Math.abs(this.speed)) : (this.angle *= noPassenger ? 0.95f : 0.75f);
        this.angle = Mth.m_14036_((float)this.angle, (float)-3.0f, (float)3.0f);
        this.m_146922_(this.m_146908_() + this.angle);
        float yRot = this.m_146908_() * ((float)Math.PI / 180);
        this.m_20334_(Mth.m_14031_((float)(-yRot)) * this.speed, this.m_20184_().f_82480_, Mth.m_14089_((float)yRot) * this.speed);
        if (zza > 0.0f) {
            this.consumeFuel();
        }
    }

    private void doEntityCollisionTick() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.m_20184_().m_82553_() <= 0.15) {
            return;
        }
        AABB aabb = this.m_20191_().m_82400_(1.001);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, aabb, entity -> !this.m_20197_().contains(entity));
        if (entities.isEmpty()) {
            return;
        }
        double power = this.m_20184_().m_82553_() * 0.4;
        float damage = (float)(power * 0.5) * 100.0f;
        float yRot = this.m_146908_() * ((float)Math.PI / 180);
        for (LivingEntity entity2 : entities) {
            entity2.m_20256_(entity2.m_20184_().m_82520_((double)Mth.m_14031_((float)(-yRot)) * 0.1, power, (double)Mth.m_14089_((float)yRot) * 0.1));
            entity2.m_6469_(ModDamageSources.ranOver(this.m_9236_(), this, (Entity)this.m_6688_()), damage);
        }
    }

    public float speed() {
        return this.speed;
    }

    public float angle() {
        return this.angle;
    }

    @Override
    @NotNull
    public String getRadioUrl() {
        return this.radioUrl;
    }

    @Override
    public void setRadioUrl(@NotNull String url) {
        this.radioUrl = url;
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundPlayStationPacket(url), player);
        }
    }

    public void consumeFuel() {
        if (this.m_9236_().m_5776_() || this.f_19797_ % 5 != 0) {
            return;
        }
        this.fluidContainer.extractFluid(this.fluidContainer.getFirstFluid().copyWithAmount(FluidConstants.fromMillibuckets((long)1L)), false);
    }

    public boolean hasEnoughFuel() {
        if (this.m_9236_().m_5776_()) {
            return (Long)this.f_19804_.m_135370_(FUEL) > 0L;
        }
        return this.fluidContainer.getFirstFluid().getFluidAmount() > 0L;
    }

    public FluidHolder fluid() {
        return FluidHolder.of((Fluid)((Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation((String)this.f_19804_.m_135370_(FUEL_TYPE)))), (long)((Long)this.f_19804_.m_135370_(FUEL)), null);
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new RoverMenu(containerId, inventory, this);
    }

    @Override
    public int getInventorySize() {
        return 18;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.ROVER.get());
    }
}

