/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.flag.content;

import com.google.common.hash.HashCode;
import earth.terrarium.adastra.common.blockentities.flag.content.ImageContent;
import earth.terrarium.adastra.common.blockentities.flag.content.UrlContent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public interface FlagContent {
    public HashCode hash();

    public String type();

    public Tag toTag();

    default public ResourceLocation toTexture() {
        return new ResourceLocation("ad_astra", "flagtextures/" + this.type() + "/" + String.valueOf(this.hash()));
    }

    default public CompoundTag toFullTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.type());
        tag.m_128365_("content", this.toTag());
        return tag;
    }

    public static FlagContent fromTag(CompoundTag tag) {
        String type = tag.m_128461_("type");
        Tag content = tag.m_128423_("content");
        if (content == null) {
            return null;
        }
        return switch (type.intern()) {
            case "image" -> ImageContent.of(content.m_7916_());
            case "url" -> UrlContent.of(content.m_7916_());
            default -> null;
        };
    }
}

