/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.components.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerWidget
extends AbstractContainerEventHandler
implements Renderable,
LayoutElement,
NarratableEntry {
    protected final List<Renderable> renderables = new ArrayList<Renderable>();
    protected final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private boolean active = true;

    public ContainerWidget(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        if (!this.active) {
            return List.of();
        }
        return this.children;
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        this.renderables.add(widget);
        this.children.add(widget);
        return widget;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.active) {
            return;
        }
        for (Renderable renderable : this.renderables) {
            renderable.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
    }

    public void m_93692_(boolean focused) {
        if (!focused) {
            this.m_7522_(null);
        }
    }

    public void m_252865_(int x) {
        this.x = x;
        this.onDimensionsChanged();
    }

    public void m_253211_(int y) {
        this.y = y;
        this.onDimensionsChanged();
    }

    public int m_252754_() {
        return this.x;
    }

    public int m_252907_() {
        return this.y;
    }

    public int m_5711_() {
        return this.width;
    }

    public int m_93694_() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
        this.onDimensionsChanged();
    }

    public void setHeight(int height) {
        this.height = height;
        this.onDimensionsChanged();
    }

    public void m_264134_(Consumer<AbstractWidget> consumer) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (guiEventListener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                consumer.accept(widget);
            }
            if (!(guiEventListener instanceof LayoutElement)) continue;
            LayoutElement layout = (LayoutElement)guiEventListener;
            layout.m_264134_(consumer);
        }
    }

    @NotNull
    public ScreenRectangle m_264198_() {
        return super.m_264198_();
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.active && mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.active && super.m_6375_(mouseX, mouseY, button);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean m_142518_() {
        return this.active;
    }

    public void onDimensionsChanged() {
    }
}

