/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.api.events;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public final class AdAstraEvents {
    private static final List<OxygenTickEvent> OXYGEN_TICK_LISTENERS = new ArrayList<OxygenTickEvent>();
    private static final List<EntityOxygenEvent> ENTITY_OXYGEN_LISTENERS = new ArrayList<EntityOxygenEvent>();
    private static final List<TemperatureTickEvent> TEMPERATURE_TICK_LISTENERS = new ArrayList<TemperatureTickEvent>();
    private static final List<HotTemperatureTickEvent> HOT_TEMPERATURE_TICK_LISTENERS = new ArrayList<HotTemperatureTickEvent>();
    private static final List<ColdTemperatureTickEvent> COLD_TEMPERATURE_TICK_LISTENERS = new ArrayList<ColdTemperatureTickEvent>();
    private static final List<EntityGravityEvent> ENTITY_GRAVITY_LISTENERS = new ArrayList<EntityGravityEvent>();
    private static final List<GravityTickEvent> GRAVITY_TICK_LISTENERS = new ArrayList<GravityTickEvent>();
    private static final List<ZeroGravityTickEvent> ZERO_GRAVITY_TICK_LISTENERS = new ArrayList<ZeroGravityTickEvent>();
    private static final List<AcidRainTickEvent> ACID_RAIN_TICK_LISTENERS = new ArrayList<AcidRainTickEvent>();
    private static final List<EnvironmentTickEvent> ENVIRONMENT_TICK_LISTENERS = new ArrayList<EnvironmentTickEvent>();

    @FunctionalInterface
    public static interface EnvironmentTickEvent {
        public boolean tick(ServerLevel var1, BlockPos var2, BlockState var3, short var4);

        public static void register(EnvironmentTickEvent listener) {
            ENVIRONMENT_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(ServerLevel level, BlockPos pos, BlockState state, short temperature) {
            for (EnvironmentTickEvent listener : ENVIRONMENT_TICK_LISTENERS) {
                if (listener.tick(level, pos, state, temperature)) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface AcidRainTickEvent {
        public boolean tick(ServerLevel var1, LivingEntity var2);

        public static void register(AcidRainTickEvent listener) {
            ACID_RAIN_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(ServerLevel level, LivingEntity entity) {
            for (AcidRainTickEvent listener : ACID_RAIN_TICK_LISTENERS) {
                if (listener.tick(level, entity)) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface ZeroGravityTickEvent {
        public boolean tick(Level var1, LivingEntity var2, Vec3 var3, BlockPos var4);

        public static void register(ZeroGravityTickEvent listener) {
            ZERO_GRAVITY_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(Level level, LivingEntity entity, Vec3 travelVector, BlockPos movementAffectingPos) {
            for (ZeroGravityTickEvent listener : ZERO_GRAVITY_TICK_LISTENERS) {
                if (listener.tick(level, entity, travelVector, movementAffectingPos)) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface EntityGravityEvent {
        public float getGravity(Entity var1, float var2);

        public static void register(EntityGravityEvent listener) {
            ENTITY_GRAVITY_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static float fire(Entity entity, float gravity) {
            for (EntityGravityEvent listener : ENTITY_GRAVITY_LISTENERS) {
                float newGravity = listener.getGravity(entity, gravity);
                if (newGravity == gravity) continue;
                return newGravity;
            }
            return gravity;
        }
    }

    @FunctionalInterface
    public static interface GravityTickEvent {
        public boolean tick(Level var1, LivingEntity var2, Vec3 var3, BlockPos var4);

        public static void register(GravityTickEvent listener) {
            GRAVITY_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(Level level, LivingEntity entity, Vec3 travelVector, BlockPos movementAffectingPos) {
            for (GravityTickEvent listener : GRAVITY_TICK_LISTENERS) {
                if (listener.tick(level, entity, travelVector, movementAffectingPos)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface ColdTemperatureTickEvent {
        public boolean tick(ServerLevel var1, LivingEntity var2);

        public static void register(ColdTemperatureTickEvent listener) {
            COLD_TEMPERATURE_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(ServerLevel level, LivingEntity entity) {
            for (ColdTemperatureTickEvent listener : COLD_TEMPERATURE_TICK_LISTENERS) {
                if (listener.tick(level, entity)) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface HotTemperatureTickEvent {
        public boolean tick(ServerLevel var1, LivingEntity var2);

        public static void register(HotTemperatureTickEvent listener) {
            HOT_TEMPERATURE_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(ServerLevel level, LivingEntity entity) {
            for (HotTemperatureTickEvent listener : HOT_TEMPERATURE_TICK_LISTENERS) {
                if (listener.tick(level, entity)) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface TemperatureTickEvent {
        public boolean tick(ServerLevel var1, LivingEntity var2);

        public static void register(TemperatureTickEvent listener) {
            TEMPERATURE_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(ServerLevel level, LivingEntity entity) {
            for (TemperatureTickEvent listener : TEMPERATURE_TICK_LISTENERS) {
                if (listener.tick(level, entity)) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface EntityOxygenEvent {
        public boolean hasOxygen(Entity var1, boolean var2);

        public static void register(EntityOxygenEvent listener) {
            ENTITY_OXYGEN_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(Entity entity, boolean hasOxygen) {
            for (EntityOxygenEvent listener : ENTITY_OXYGEN_LISTENERS) {
                boolean newOxygen = listener.hasOxygen(entity, hasOxygen);
                if (newOxygen == hasOxygen) continue;
                return newOxygen;
            }
            return hasOxygen;
        }
    }

    @FunctionalInterface
    public static interface OxygenTickEvent {
        public boolean tick(ServerLevel var1, LivingEntity var2);

        public static void register(OxygenTickEvent listener) {
            OXYGEN_TICK_LISTENERS.add(listener);
        }

        @ApiStatus.Internal
        public static boolean fire(ServerLevel level, LivingEntity entity) {
            for (OxygenTickEvent listener : OXYGEN_TICK_LISTENERS) {
                if (listener.tick(level, entity)) continue;
                return false;
            }
            return true;
        }
    }
}

