/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import java.util.List;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TabbedPanel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Functions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public abstract class AbstractParameterEditor
implements ParameterEditor {
    public static final String PAGE_CONSTANT = "Constant";
    public static final String PAGE_VARIABLE = "Variable";
    public static final String PAGE_FUNCTION = "Function";
    private TextField variableIndex;
    private TabbedPanel tabbedPanel;
    private Panel buttonPanel;
    private ChoiceLabel functionLabel;
    private ToggleButton variableButton;
    private ToggleButton functionButton;
    private Runnable onClose;
    private Window parentWindow;

    @Override
    public void constantOnly() {
        this.variableButton.enabled(false);
        this.functionButton.enabled(false);
    }

    @Override
    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    @Override
    public void initialFocus(Window window) {
        this.parentWindow = window;
        if (PAGE_CONSTANT.equals(this.tabbedPanel.getCurrentName())) {
            this.initialFocusInternal(window);
        } else if (PAGE_VARIABLE.equals(this.tabbedPanel.getCurrentName())) {
            this.initialFocusVariable(window);
        }
    }

    protected void closeWindow() {
        if (this.parentWindow != null) {
            this.parentWindow.getWindowManager().closeWindow(this.parentWindow);
        }
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    protected void initialFocusInternal(Window window) {
    }

    private void initialFocusVariable(Window window) {
        window.setTextFocus((Widget)this.variableIndex);
    }

    public static Integer parseIntSafe(String newText) {
        Integer f;
        if (newText == null || newText.isEmpty()) {
            return null;
        }
        try {
            f = newText.startsWith("$") ? Integer.valueOf((int)Long.parseLong(newText.substring(1), 16)) : Integer.valueOf(Integer.parseInt(newText));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static Long parseLongSafe(String newText) {
        Long f;
        if (newText == null || newText.isEmpty()) {
            return null;
        }
        try {
            f = newText.startsWith("$") ? Long.valueOf(Long.parseLong(newText.substring(1), 16)) : Long.valueOf(Long.parseLong(newText));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static Float parseFloatSafe(String newText) {
        Float f;
        try {
            f = Float.valueOf(Float.parseFloat(newText));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static Double parseDoubleSafe(String newText) {
        Double f;
        try {
            f = Double.parseDouble(newText);
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    protected abstract ParameterValue readConstantValue();

    protected abstract void writeConstantValue(ParameterValue var1);

    @Override
    public ParameterValue readValue() {
        if (PAGE_CONSTANT.equals(this.tabbedPanel.getCurrentName())) {
            return this.readConstantValue();
        }
        if (PAGE_VARIABLE.equals(this.tabbedPanel.getCurrentName())) {
            Integer var = AbstractParameterEditor.parseIntSafe(this.variableIndex.getText());
            if (var != null) {
                return ParameterValue.variable((int)var);
            }
            return ParameterValue.variable((int)0);
        }
        if (PAGE_FUNCTION.equals(this.tabbedPanel.getCurrentName())) {
            String currentChoice = this.functionLabel.getCurrentChoice();
            return ParameterValue.function((Function)Functions.FUNCTIONS.get(currentChoice));
        }
        return null;
    }

    @Override
    public void writeValue(ParameterValue value) {
        if (value == null || value.isConstant()) {
            this.switchPage(PAGE_CONSTANT, null);
            this.writeConstantValue(value);
        } else if (value.isVariable()) {
            this.switchPage(PAGE_VARIABLE, null);
            this.variableIndex.text(Integer.toString(value.getVariableIndex()));
        } else if (value.isFunction()) {
            this.switchPage(PAGE_FUNCTION, null);
            String id = value.getFunction().getId();
            this.functionLabel.choice(id);
        }
    }

    protected Panel createLabeledPanel(Minecraft mc, Screen gui, String label, Widget<?> object, String ... tooltips) {
        object.tooltips(tooltips);
        return (Panel)Widgets.horizontal().children(new Widget[]{object, ((Label)((Label)Widgets.label((String)label).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).tooltips(tooltips)).desiredWidth(60)});
    }

    void createEditorPanel(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback, Panel constantPanel, ParameterType type) {
        Panel variablePanel = (Panel)Widgets.horizontal().desiredHeight(18);
        this.variableIndex = ((TextField)((TextField)new TextField().desiredHeight(14)).tooltips(new String[]{"Index (in the processor)", "of the variable", "(first variable has index 0)"})).event(newText -> callback.valueChanged(this.readValue()));
        ((Panel)((Panel)variablePanel.children(new Widget[]{this.variableIndex, Widgets.label((String)"Index:")})).tooltips(new String[]{"Index (in the processor)", "of the variable", "(first variable has index 0)"})).desiredHeight(14);
        Panel functionPanel = Widgets.horizontal();
        this.functionLabel = (ChoiceLabel)new ChoiceLabel().desiredWidth(120);
        List<Function> functions = Functions.getFunctionsByType(type);
        for (Function function : functions) {
            this.functionLabel.choices(new String[]{function.getId()});
            this.functionLabel.choiceTooltip(function.getId(), function.getDescription().toArray(new String[function.getDescription().size()]));
        }
        if (type == ParameterType.PAR_NUMBER) {
            functions = Functions.getFunctionsByType(ParameterType.PAR_INTEGER);
            for (Function function : functions) {
                this.functionLabel.choices(new String[]{function.getId()});
                this.functionLabel.choiceTooltip(function.getId(), function.getDescription().toArray(new String[function.getDescription().size()]));
            }
        }
        functionPanel.children(new Widget[]{this.functionLabel});
        this.functionLabel.event(newChoice -> callback.valueChanged(this.readValue()));
        this.tabbedPanel = new TabbedPanel().page(PAGE_CONSTANT, (Widget)constantPanel).page(PAGE_VARIABLE, (Widget)variablePanel).page(PAGE_FUNCTION, (Widget)functionPanel);
        this.tabbedPanel.hint(5, 23, 180, 60 + this.getHeight() - 5 - 18 - 40);
        this.buttonPanel = (Panel)Widgets.horizontal().hint(5, 5, 180, 18);
        ToggleButton constantButton = ((ToggleButton)new ToggleButton().text(PAGE_CONSTANT)).event(() -> this.switchPage(PAGE_CONSTANT, callback));
        this.variableButton = ((ToggleButton)new ToggleButton().text(PAGE_VARIABLE)).event(() -> this.switchPage(PAGE_VARIABLE, callback));
        this.functionButton = ((ToggleButton)new ToggleButton().text(PAGE_FUNCTION)).event(() -> this.switchPage(PAGE_FUNCTION, callback));
        this.buttonPanel.children(new Widget[]{constantButton, this.variableButton, this.functionButton});
        panel.children(new Widget[]{this.buttonPanel, this.tabbedPanel});
    }

    private void switchPage(String page, ParameterEditorCallback callback) {
        for (int i = 0; i < this.buttonPanel.getChildCount(); ++i) {
            ToggleButton button = (ToggleButton)this.buttonPanel.getChild(i);
            if (!page.equals(button.getText())) {
                button.pressed(false);
            } else {
                button.pressed(true);
            }
            this.tabbedPanel.current(page);
            if (callback == null) continue;
            callback.valueChanged(this.readValue());
        }
        if (this.parentWindow != null) {
            if (PAGE_CONSTANT.equals(page)) {
                this.initialFocusInternal(this.parentWindow);
            } else if (PAGE_VARIABLE.equals(page)) {
                this.initialFocusVariable(this.parentWindow);
            }
        }
    }
}

