/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.client;

import javax.annotation.Nonnull;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.multitank.MultiTankModule;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankTileEntity;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;

public class GuiMultiTank
extends GenericGuiContainer<MultiTankTileEntity, GenericContainer> {
    public static final int WIDTH = 180;
    public static final int HEIGHT = 87;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolscontrol", "textures/gui/tank.png");
    private int listDirty = 0;
    private final BlockRender[] liquids = new BlockRender[4];
    private final Label[] labels = new Label[4];

    public GuiMultiTank(MultiTankTileEntity te, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)te, (AbstractContainerMenu)container, inventory, ManualEntry.EMPTY);
        this.f_97726_ = 180;
        this.f_97727_ = 87;
    }

    public static void register() {
        GuiMultiTank.register(MultiTankModule.MULTITANK_CONTAINER.get(), GuiMultiTank::new);
    }

    public void m_7856_() {
        super.m_7856_();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        for (int i = 0; i < 4; ++i) {
            this.liquids[i] = (BlockRender)new BlockRender().hint(10, 9 + i * 18, 16, 16);
            toplevel.children(new Widget[]{this.liquids[i]});
            this.labels[i] = (Label)((Label)Widgets.label((int)32, (int)(9 + i * 18), (int)142, (int)16, (String)"").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).verticalAlignment(VerticalAlignment.ALIGN_CENTER);
            toplevel.children(new Widget[]{this.labels[i]});
        }
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void requestLists() {
        Networking.sendToServer((Object)PacketGetListFromServer.create((BlockPos)((MultiTankTileEntity)this.tileEntity).m_58899_(), (String)MultiTankTileEntity.CMD_GETFLUIDS.name()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void updateLiquids() {
        this.requestListsIfNeeded();
        MultiTankFluidProperties[] properties = ((MultiTankTileEntity)this.tileEntity).getProperties();
        for (int i = 0; i < 4; ++i) {
            FluidStack stack;
            if (i < properties.length && properties[i] != null && !(stack = properties[i].getContents()).isEmpty()) {
                this.liquids[i].renderItem((Object)stack);
                this.labels[i].text(stack.getDisplayName().getString() + " (" + stack.getAmount() + "mb)");
                continue;
            }
            this.liquids[i].renderItem(null);
            this.labels[i].text("");
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.updateLiquids();
        this.drawWindow(graphics);
    }
}

