/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.util;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.network.NetworkTools;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class CraftingRequest {
    private final String ticket;
    private final ItemStack stack;
    private long failed = -1L;
    private long ok = -1L;
    private int todo = 0;

    public CraftingRequest(String ticket, ItemStack stack, int todo) {
        this.ticket = ticket;
        this.stack = stack;
        this.todo = todo;
    }

    public String getTicket() {
        return this.ticket;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public long getFailed() {
        return this.failed;
    }

    public void setFailed(long failed) {
        this.failed = failed;
    }

    public long getOk() {
        return this.ok;
    }

    public void setOk(long ok) {
        this.ok = ok;
    }

    public int getTodo() {
        return this.todo;
    }

    public void setTodo(int todo) {
        this.todo = todo;
    }

    public void decrTodo() {
        --this.todo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftingRequest that = (CraftingRequest)o;
        return this.ticket.equals(that.ticket);
    }

    public int hashCode() {
        return this.ticket.hashCode();
    }

    public static class Serializer
    implements ISerializer<CraftingRequest> {
        public Function<FriendlyByteBuf, CraftingRequest> getDeserializer() {
            return buf -> {
                String id = buf.m_130136_(Short.MAX_VALUE);
                ItemStack stack1 = NetworkTools.readItemStack((FriendlyByteBuf)buf);
                int amount = buf.readInt();
                CraftingRequest request = new CraftingRequest(id, stack1, amount);
                request.setOk(buf.readLong());
                request.setFailed(buf.readLong());
                return request;
            };
        }

        public BiConsumer<FriendlyByteBuf, CraftingRequest> getSerializer() {
            return (buf, item) -> {
                buf.m_130070_(item.getTicket());
                NetworkTools.writeItemStack((FriendlyByteBuf)buf, (ItemStack)item.getStack());
                buf.writeInt(item.getTodo());
                buf.writeLong(item.getOk());
                buf.writeLong(item.getFailed());
            };
        }
    }
}

