/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.Nullable;
import trofers.util.JsonHelper;

public record EffectInfo(@Nullable SoundInfo sound, RewardInfo rewards) {
    public static final EffectInfo NONE = new EffectInfo(null, RewardInfo.NONE);

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.sound() != null);
        if (this.sound() != null) {
            this.sound().toNetwork(buffer);
        }
        this.rewards().toNetwork(buffer);
    }

    public static EffectInfo fromNetwork(FriendlyByteBuf buffer) {
        SoundInfo sound = null;
        if (buffer.readBoolean()) {
            sound = SoundInfo.fromNetwork(buffer);
        }
        RewardInfo rewards = RewardInfo.fromNetwork(buffer);
        return new EffectInfo(sound, rewards);
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        if (this.sound() != null) {
            object.add("sound", (JsonElement)this.sound().toJson());
        }
        if (!this.rewards().equals(RewardInfo.NONE)) {
            object.add("rewards", (JsonElement)this.rewards().toJson());
        }
        return object;
    }

    public static EffectInfo fromJson(JsonObject object) {
        SoundInfo sound = null;
        if (object.has("sound")) {
            sound = SoundInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"sound"));
        }
        RewardInfo rewards = RewardInfo.NONE;
        if (object.has("rewards")) {
            rewards = RewardInfo.fromJson(GsonHelper.m_13930_((JsonObject)object, (String)"rewards"));
        }
        return new EffectInfo(sound, rewards);
    }

    public record SoundInfo(ResourceLocation soundEvent, float volume, float pitch) {
        private void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.soundEvent());
            buffer.writeFloat(this.volume());
            buffer.writeFloat(this.pitch());
        }

        private static SoundInfo fromNetwork(FriendlyByteBuf buffer) {
            return new SoundInfo(buffer.m_130281_(), buffer.readFloat(), buffer.readFloat());
        }

        private JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("soundEvent", this.soundEvent().toString());
            if (this.volume() != 1.0f) {
                result.addProperty("volume", (Number)Float.valueOf(this.volume()));
            }
            if (this.pitch() != 1.0f) {
                result.addProperty("pitch", (Number)Float.valueOf(this.pitch()));
            }
            return result;
        }

        private static SoundInfo fromJson(JsonObject object) {
            ResourceLocation soundEvent = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"soundEvent"));
            float volume = JsonHelper.readOptionalFloat(object, "volume", 1);
            float pitch = JsonHelper.readOptionalFloat(object, "pitch", 1);
            return new SoundInfo(soundEvent, volume, pitch);
        }
    }

    public record RewardInfo(@Nullable ResourceLocation lootTable, CompoundTag statusEffect, int cooldown) {
        public static RewardInfo NONE = new RewardInfo(null, new CompoundTag(), 0);

        @Nullable
        public MobEffectInstance createStatusEffect() {
            if (!this.statusEffect().m_128456_()) {
                return MobEffectInstance.m_19560_((CompoundTag)this.statusEffect());
            }
            return null;
        }

        private void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.lootTable() != null);
            if (this.lootTable() != null) {
                buffer.m_130085_(this.lootTable());
            }
            buffer.m_130079_(this.statusEffect());
            buffer.writeInt(this.cooldown());
        }

        private static RewardInfo fromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation lootTable = null;
            if (buffer.readBoolean()) {
                lootTable = buffer.m_130281_();
            }
            CompoundTag statusEffect = buffer.m_130260_();
            int cooldown = buffer.readInt();
            return new RewardInfo(lootTable, statusEffect, cooldown);
        }

        private JsonObject toJson() {
            MobEffectInstance effect;
            JsonObject result = new JsonObject();
            if (this.lootTable() != null) {
                result.addProperty("lootTable", this.lootTable().toString());
            }
            if (!this.statusEffect().m_128456_() && (effect = MobEffectInstance.m_19560_((CompoundTag)this.statusEffect())) != null) {
                JsonObject statusEffect = new JsonObject();
                result.add("statusEffect", (JsonElement)statusEffect);
                statusEffect.addProperty("effect", BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_()).toString());
                statusEffect.addProperty("duration", (Number)effect.m_19557_());
                if (effect.m_19564_() != 0) {
                    statusEffect.addProperty("amplifier", (Number)effect.m_19564_());
                }
            }
            if (this.cooldown() != 0) {
                result.addProperty("cooldown", (Number)this.cooldown());
            }
            return result;
        }

        private static RewardInfo fromJson(JsonObject object) {
            ResourceLocation lootTable = null;
            if (object.has("lootTable")) {
                lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"lootTable"));
            }
            CompoundTag statusEffect = new CompoundTag();
            if (object.has("statusEffect")) {
                JsonObject effectObject = GsonHelper.m_13930_((JsonObject)object, (String)"statusEffect");
                ResourceLocation effectID = new ResourceLocation(GsonHelper.m_13906_((JsonObject)effectObject, (String)"effect"));
                if (!BuiltInRegistries.f_256974_.m_7804_(effectID)) {
                    throw new JsonParseException(String.format("Unknown effect: %s", effectID));
                }
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectID);
                int duration = GsonHelper.m_13927_((JsonObject)effectObject, (String)"duration");
                int amplifier = 0;
                if (effectObject.has("amplifier")) {
                    amplifier = GsonHelper.m_13927_((JsonObject)effectObject, (String)"amplifier");
                }
                statusEffect = new MobEffectInstance(effect, duration, amplifier).m_19555_(new CompoundTag());
            }
            int cooldown = 0;
            if (object.has("cooldown")) {
                cooldown = GsonHelper.m_13927_((JsonObject)object, (String)"cooldown");
            }
            return new RewardInfo(lootTable, statusEffect, cooldown);
        }
    }
}

