/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftbchunks.client.gui.ToggleVisibilityButton;
import dev.ftb.mods.ftbchunks.client.gui.WaypointShareMenu;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.net.TeleportFromMapPacket;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorSelectorPanel;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientTextComponentUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class WaypointEditorScreen
extends AbstractButtonListScreen {
    private final Map<ResourceKey<Level>, Boolean> collapsed = new HashMap<ResourceKey<Level>, Boolean>();
    private final Map<ResourceKey<Level>, List<WaypointImpl>> waypoints = new HashMap<ResourceKey<Level>, List<WaypointImpl>>();
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;

    public WaypointEditorScreen() {
        this.showBottomPanel(false);
        this.showCloseButton(true);
        for (Map.Entry<ResourceKey<Level>, List<WaypointImpl>> resourceKeyListEntry : WaypointEditorScreen.collectWaypoints().entrySet()) {
            this.collapsed.put(resourceKeyListEntry.getKey(), false);
            this.waypoints.put(resourceKeyListEntry.getKey(), new ArrayList(resourceKeyListEntry.getValue()));
        }
        this.buttonExpandAll = new SimpleButton(this.topPanel, List.of(Component.m_237115_((String)"gui.expand_all"), TextComponentUtils.hotkeyTooltip((String)"="), TextComponentUtils.hotkeyTooltip((String)"+")), Icons.UP, (widget, button) -> this.toggleAll(false));
        this.buttonCollapseAll = new SimpleButton(this.topPanel, List.of(Component.m_237115_((String)"gui.collapse_all"), TextComponentUtils.hotkeyTooltip((String)"-")), Icons.DOWN, (widget, button) -> this.toggleAll(true));
    }

    private void toggleAll(boolean collapsed) {
        this.collapsed.keySet().forEach(levelResourceKey -> this.collapsed.put((ResourceKey<Level>)levelResourceKey, collapsed));
        this.scrollBar.setValue(0.0);
        this.getGui().refreshWidgets();
    }

    protected void doCancel() {
    }

    protected void doAccept() {
    }

    public boolean onInit() {
        this.setWidth(220);
        this.setHeight(this.getScreen().m_85446_() * 4 / 5);
        return true;
    }

    protected int getTopPanelHeight() {
        return 22;
    }

    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    public void addButtons(Panel panel) {
        this.waypoints.forEach((key, value) -> {
            boolean startCollapsed = this.collapsed.get(key);
            GroupButton groupButton = new GroupButton(panel, (ResourceKey<Level>)key, startCollapsed, (List<WaypointImpl>)value);
            panel.add((Widget)groupButton);
            if (!startCollapsed) {
                panel.addAll(groupButton.collectPanels());
            }
        });
    }

    private static Map<ResourceKey<Level>, List<WaypointImpl>> collectWaypoints() {
        HashMap<ResourceKey<Level>, List<WaypointImpl>> res = new HashMap<ResourceKey<Level>, List<WaypointImpl>>();
        Player player = (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        MapManager manager = MapManager.getInstance().orElseThrow();
        manager.getDimensions().values().stream().filter(dim -> !dim.getWaypointManager().isEmpty()).sorted((dim1, dim2) -> {
            ResourceLocation dim1id = dim1.dimension.m_135782_();
            ResourceLocation dim2id = dim2.dimension.m_135782_();
            if (dim1id.m_135827_().equals("minecraft") && !dim2id.m_135827_().equals("minecraft")) {
                return -1;
            }
            int i = dim1id.m_135827_().compareTo(dim2id.m_135827_());
            return i == 0 ? dim1id.m_135815_().compareTo(dim2id.m_135815_()) : i;
        }).forEach(dim -> res.put(dim.dimension, dim.getWaypointManager().stream().sorted(Comparator.comparingDouble(wp -> wp.getDistanceSq((Entity)player))).toList()));
        return res;
    }

    protected class CustomTopPanel
    extends AbstractThreePanelScreen.TopPanel {
        private final TextField titleLabel;

        protected CustomTopPanel() {
            super((AbstractThreePanelScreen)WaypointEditorScreen.this);
            this.titleLabel = new TextField((Panel)this);
        }

        public void addWidgets() {
            this.titleLabel.setText((Component)Component.m_237115_((String)"ftbchunks.gui.waypoints"));
            this.titleLabel.addFlags(32);
            this.add((Widget)this.titleLabel);
            if (WaypointEditorScreen.this.waypoints.size() > 1) {
                this.add((Widget)WaypointEditorScreen.this.buttonExpandAll);
                this.add((Widget)WaypointEditorScreen.this.buttonCollapseAll);
            }
        }

        public void alignWidgets() {
            this.titleLabel.setPosAndSize(4, 0, this.titleLabel.width, this.height);
            if (WaypointEditorScreen.this.waypoints.size() > 1) {
                WaypointEditorScreen.this.buttonExpandAll.setPos(this.width - 18, 2);
                WaypointEditorScreen.this.buttonCollapseAll.setPos(this.width - 38, 2);
            }
        }
    }

    private class GroupButton
    extends Button {
        private final Component titleText;
        private final List<RowPanel> rowPanels;
        private final ResourceKey<Level> dim;

        public GroupButton(Panel panel, ResourceKey<Level> dim, boolean startCollapsed, List<WaypointImpl> waypoints) {
            super(panel);
            this.dim = dim;
            this.titleText = TextComponentUtils.translatedDimension(dim).m_6881_().m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)dim.m_135782_().toString()))));
            this.setCollapsed(startCollapsed);
            this.rowPanels = new ArrayList<RowPanel>();
            for (WaypointImpl waypoint : waypoints) {
                this.rowPanels.add(new RowPanel(panel, waypoint));
            }
        }

        public List<RowPanel> collectPanels() {
            return this.isCollapsed() ? List.of() : List.copyOf(this.rowPanels);
        }

        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.isCollapsed());
            this.parent.refreshWidgets();
            WaypointEditorScreen.this.refreshWidgets();
            this.playClickSound();
        }

        public boolean isCollapsed() {
            return WaypointEditorScreen.this.collapsed.get(this.dim);
        }

        public void setCollapsed(boolean collapsed) {
            WaypointEditorScreen.this.collapsed.put(this.dim, collapsed);
            boolean isCollapsed = this.isCollapsed();
            this.setTitle((Component)Component.m_237113_((String)(isCollapsed ? "\u25b6 " : "\u25bc ")).m_130940_(isCollapsed ? ChatFormatting.RED : ChatFormatting.GREEN).m_7220_(this.titleText));
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawWidget(graphics, x, y, w, h, this.getWidgetType());
            theme.drawString(graphics, (Object)this.getTitle(), x + 3, y + 3);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
        }

        public void addMouseOverText(TooltipList list) {
            list.add((Component)Component.m_237113_((String)this.dim.m_135782_().toString()));
        }
    }

    private class RowPanel
    extends Panel {
        private static final Component DELETE = Component.m_237115_((String)"ftbchunks.gui.delete");
        private static final Component QUICK_DELETE = Component.m_237115_((String)"ftbchunks.gui.quick_delete");
        private final WaypointImpl wp;
        private TextField nameField;
        private TextField distField;
        private SimpleButton hideButton;
        private SimpleButton deleteButton;

        public RowPanel(Panel panel, WaypointImpl wp) {
            super(panel);
            this.wp = wp;
            this.setHeight(18);
        }

        public void addWidgets() {
            this.hideButton = ToggleVisibilityButton.create(this, !this.wp.isHidden(), hidden -> this.wp.setHidden(hidden == false));
            this.add((Widget)this.hideButton);
            this.nameField = new TextField((Panel)this).setTrim().setColor(Color4I.rgb((int)this.wp.getColor())).addFlags(2);
            this.add((Widget)this.nameField);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            String distStr = player.m_9236_().m_46472_().equals(this.wp.getDimension()) ? String.format("%.1fm", Math.sqrt(this.wp.getDistanceSq((Entity)player))) : "";
            this.distField = new TextField((Panel)this).setText(distStr).setColor(Color4I.WHITE);
            this.add((Widget)this.distField);
            this.deleteButton = new SimpleButton(this, DELETE, Icons.BIN, (w, mb) -> this.deleteWaypoint(!RowPanel.isShiftKeyDown())){

                public Component getTitle() {
                    return 1.isShiftKeyDown() ? QUICK_DELETE : DELETE;
                }

                public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                    super.drawIcon(graphics, theme, x, y, 12, 12);
                }
            };
            this.add((Widget)this.deleteButton);
        }

        public void alignWidgets() {
        }

        public void setWidth(int newWidth) {
            super.setWidth(newWidth);
            if (newWidth > 0) {
                int farRight = newWidth - 8;
                int yOff = (this.height - WaypointEditorScreen.this.getTheme().getFontHeight()) / 2 + 1;
                this.hideButton.setPosAndSize(farRight - 8 - 16, 1, 12, 12);
                this.deleteButton.setPosAndSize(farRight - 8, 1, 12, 12);
                this.distField.setPos(this.hideButton.getPosX() - 5 - this.distField.width, yOff);
                this.nameField.setPos(5, yOff);
                this.nameField.setText(ClientTextComponentUtils.ellipsize((Font)WaypointEditorScreen.this.getTheme().getFont(), (FormattedText)Component.m_237113_((String)this.wp.getName()), (int)(this.distField.getPosX() - 5)).getString());
                this.nameField.setHeight(WaypointEditorScreen.this.getTheme().getFontHeight() + 2);
            }
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            super.draw(graphics, theme, x, y, w, h);
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && button.isRight()) {
                ArrayList<ContextMenuItem> list = new ArrayList<ContextMenuItem>();
                list.add(this.makeTitleMenuItem());
                list.add(ContextMenuItem.SEPARATOR);
                WaypointShareMenu.makeShareMenu((Player)Minecraft.m_91087_().f_91074_, this.wp).ifPresent(list::add);
                list.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.rename"), Icons.CHAT, btn -> {
                    StringConfig config = new StringConfig();
                    config.setDefaultValue((Object)"");
                    config.setValue((Object)this.wp.getName());
                    config.onClicked((Widget)btn, MouseButton.LEFT, accepted -> {
                        if (accepted) {
                            this.wp.setName((String)config.getValue());
                        }
                        this.openGui();
                    });
                }));
                if (this.wp.getType().canChangeColor()) {
                    list.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbchunks.gui.change_color"), Icons.COLOR_RGB, btn -> {
                        ColorConfig col = new ColorConfig();
                        col.setValue((Object)Color4I.rgb((int)this.wp.getColor()));
                        ColorSelectorPanel.popupAtMouse((BaseScreen)btn.getGui(), (ColorConfig)col, accepted -> {
                            if (accepted) {
                                this.wp.setColor(((Color4I)col.getValue()).rgba());
                                this.wp.refreshIcon();
                                Object patt11161$temp = this.widgets.get(1);
                                if (patt11161$temp instanceof TextField) {
                                    TextField tf = (TextField)patt11161$temp;
                                    tf.setColor(Color4I.rgb((int)this.wp.getColor()));
                                }
                            }
                        });
                    }));
                }
                if (Minecraft.m_91087_().f_91074_.m_20310_(2)) {
                    list.add(new ContextMenuItem((Component)Component.m_237115_((String)"ftbchunks.gui.teleport"), ItemIcon.getItemIcon((Item)Items.f_42584_), btn -> {
                        new TeleportFromMapPacket(this.wp.getPos().m_7494_(), false, this.wp.getDimension()).sendToServer();
                        this.closeGui(false);
                    }));
                }
                list.add(new ContextMenuItem((Component)Component.m_237115_((String)"gui.remove"), Icons.REMOVE, btn -> this.deleteWaypoint(true)));
                this.getGui().openContextMenu(list);
                return true;
            }
            return super.mousePressed(button);
        }

        public boolean keyPressed(Key key) {
            if (key.is(261)) {
                this.deleteWaypoint(!RowPanel.isShiftKeyDown());
                return true;
            }
            return super.keyPressed(key);
        }

        private void deleteWaypoint(boolean gui) {
            if (gui) {
                this.getGui().openYesNo((Component)Component.m_237110_((String)"ftbchunks.gui.delete_waypoint", (Object[])new Object[]{Component.m_237113_((String)this.wp.getName()).m_130948_(Style.f_131099_.m_178520_(this.wp.getColor()))}), (Component)Component.m_237119_(), () -> {
                    this.wp.removeFromManager();
                    WaypointEditorScreen.this.waypoints.get(this.wp.getDimension()).remove(this.wp);
                    this.getGui().refreshWidgets();
                });
            } else {
                this.wp.removeFromManager();
                WaypointEditorScreen.this.waypoints.get(this.wp.getDimension()).remove(this.wp);
                this.getGui().refreshWidgets();
            }
        }

        private ContextMenuItem makeTitleMenuItem() {
            return new ContextMenuItem((Component)Component.m_237113_((String)this.wp.getName()), (Icon)Icon.empty(), null){

                public Icon getIcon() {
                    return RowPanel.this.wp.getType().getIcon().withTint(Color4I.rgb((int)RowPanel.this.wp.getColor()));
                }
            };
        }
    }
}

