/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.api;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraftforge.fart.api.IdentifierFixerConfig;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.fart.api.SignatureStripperConfig;
import net.minecraftforge.fart.api.SourceFixerConfig;
import net.minecraftforge.fart.internal.EntryImpl;
import net.minecraftforge.fart.internal.FFLineFixer;
import net.minecraftforge.fart.internal.IdentifierFixer;
import net.minecraftforge.fart.internal.ParameterAnnotationFixer;
import net.minecraftforge.fart.internal.RecordFixer;
import net.minecraftforge.fart.internal.RenamingTransformer;
import net.minecraftforge.fart.internal.SignatureStripperTransformer;
import net.minecraftforge.fart.internal.SourceFixer;
import net.minecraftforge.srgutils.IMappingFile;

public interface Transformer {
    default public ClassEntry process(ClassEntry entry) {
        return entry;
    }

    default public ManifestEntry process(ManifestEntry entry) {
        return entry;
    }

    default public ResourceEntry process(ResourceEntry entry) {
        return entry;
    }

    default public Collection<? extends Entry> getExtras() {
        return Collections.emptyList();
    }

    @Deprecated
    public static Transformer createRenamer(Inheritance inh, IMappingFile map) {
        return new RenamingTransformer(inh, map, System.out::println);
    }

    public static Factory renamerFactory(IMappingFile map) {
        return ctx -> new RenamingTransformer(ctx.getInheritance(), map, ctx.getLog());
    }

    public static Factory identifierFixerFactory(IdentifierFixerConfig config) {
        return ctx -> new IdentifierFixer(config);
    }

    public static Factory parameterAnnotationFixerFactory() {
        return ctx -> new ParameterAnnotationFixer(ctx.getLog(), ctx.getDebug());
    }

    public static Factory fernFlowerLineFixerFactory(File sourceJar) {
        return ctx -> new FFLineFixer(ctx.getDebug(), sourceJar);
    }

    public static Factory recordFixerFactory() {
        return ctx -> RecordFixer.INSTANCE;
    }

    public static Factory sourceFixerFactory(SourceFixerConfig config) {
        return ctx -> new SourceFixer(config);
    }

    public static Factory signatureStripperFactory(SignatureStripperConfig config) {
        return ctx -> new SignatureStripperTransformer(ctx.getLog(), config);
    }

    public static interface Context {
        public Consumer<String> getLog();

        public Consumer<String> getDebug();

        public Inheritance getInheritance();
    }

    public static interface Factory {
        public static Factory always(Transformer transformer) {
            Objects.requireNonNull(transformer, "transformer");
            return ctx -> transformer;
        }

        public Transformer create(Context var1);
    }

    public static interface ManifestEntry
    extends Entry {
        public static ManifestEntry create(long time, byte[] data) {
            return new EntryImpl.ManifestEntry(time, data);
        }
    }

    public static interface ResourceEntry
    extends Entry {
        public static ResourceEntry create(String name, long time, byte[] data) {
            return new EntryImpl.ResourceEntry(name, time, data);
        }
    }

    public static interface ClassEntry
    extends Entry {
        public static ClassEntry create(String name, long time, byte[] data) {
            return new EntryImpl.ClassEntry(name, time, data);
        }

        public static ClassEntry create(String cls, long time, byte[] data, int version) {
            return ClassEntry.create("META-INF/versions/" + version + '/' + cls + ".class", time, data);
        }

        public String getClassName();

        public boolean isMultiRelease();

        public int getVersion();
    }

    public static interface Entry {
        public static final long STABLE_TIMESTAMP = 946684800L;

        public long getTime();

        public String getName();

        public byte[] getData();

        public Entry process(Transformer var1);
    }
}

