/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.mightymail.util;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape rotateHorizontally(VoxelShape shape, Direction direction) {
        Preconditions.checkArgument((boolean)direction.m_122434_().m_122479_());
        return shape.m_83299_().stream().map(box -> VoxelShapeHelper.createRotatedShape(box, direction)).reduce(Shapes.m_83040_(), VoxelShapeHelper::join);
    }

    public static VoxelShape combine(List<VoxelShape> shapes) {
        return shapes.stream().reduce(Shapes.m_83040_(), VoxelShapeHelper::join).m_83296_();
    }

    private static VoxelShape join(VoxelShape a, VoxelShape b) {
        return Shapes.m_83148_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_);
    }

    private static VoxelShape createRotatedShape(AABB box, Direction direction) {
        return switch (direction) {
            case Direction.WEST -> Shapes.m_83048_((double)(1.0 - box.f_82291_), (double)box.f_82289_, (double)(1.0 - box.f_82293_), (double)(1.0 - box.f_82288_), (double)box.f_82292_, (double)(1.0 - box.f_82290_));
            case Direction.NORTH -> Shapes.m_83048_((double)box.f_82290_, (double)box.f_82289_, (double)(1.0 - box.f_82291_), (double)box.f_82293_, (double)box.f_82292_, (double)(1.0 - box.f_82288_));
            case Direction.SOUTH -> Shapes.m_83048_((double)(1.0 - box.f_82293_), (double)box.f_82289_, (double)box.f_82288_, (double)(1.0 - box.f_82290_), (double)box.f_82292_, (double)box.f_82291_);
            default -> Shapes.m_83048_((double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_, (double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_);
        };
    }
}

