/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge;

import java.nio.file.Path;
import net.creeperhost.polylib.forge.inventory.energy.ForgeEnergyManager;
import net.creeperhost.polylib.forge.inventory.energy.ForgeItemEnergyManager;
import net.creeperhost.polylib.forge.inventory.fluid.ForgeFluidManager;
import net.creeperhost.polylib.inventory.energy.PlatformEnergyManager;
import net.creeperhost.polylib.inventory.energy.PlatformItemEnergyManager;
import net.creeperhost.polylib.inventory.fluid.FluidManager;
import net.creeperhost.polylib.inventory.power.EnergyManager;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.loading.FMLPaths;

public class PolyLibPlatformImpl {
    private static final FluidManager FLUID_MANAGER = new ForgeFluidManager();
    private static final EnergyManager ENERGY_MANAGER = new net.creeperhost.polylib.forge.inventory.power.ForgeEnergyManager();

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static PlatformItemEnergyManager getItemEnergyManager(ItemStack stack) {
        return new ForgeItemEnergyManager((CapabilityProvider<?>)stack);
    }

    public static PlatformEnergyManager getBlockEnergyManager(BlockEntity entity, Direction direction) {
        return new ForgeEnergyManager((CapabilityProvider<?>)entity, direction);
    }

    public static boolean isEnergyItem(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static boolean isEnergyContainer(BlockEntity block, Direction direction) {
        return block.getCapability(ForgeCapabilities.ENERGY, direction).isPresent();
    }

    public static FluidManager getFluidManager() {
        return FLUID_MANAGER;
    }

    public static EnergyManager getEnergyManager() {
        return ENERGY_MANAGER;
    }
}

