/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.aebettervillagers.join;

import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ae_better_villagers", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FirstJoinMessageHandler {
    private static ForgeConfigSpec.BooleanValue enabled;
    private static ForgeConfigSpec.ConfigValue<String> welcomeMessage;
    private static ForgeConfigSpec.ConfigValue<String> clickableUrl;
    public static final ForgeConfigSpec COMMON_SPEC;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((Boolean)enabled.get()).booleanValue() && FirstJoinMessageHandler.isFirstJoin(player2)) {
                Component message = FirstJoinMessageHandler.createClickableMessage();
                player2.m_213846_(message);
                FirstJoinMessageHandler.markPlayerAsJoined(player2);
            }
        }
    }

    private static boolean isFirstJoin(ServerPlayer player) {
        return !player.getPersistentData().m_128471_("hasJoinedBefore");
    }

    private static void markPlayerAsJoined(ServerPlayer player) {
        player.getPersistentData().m_128379_("hasJoinedBefore", true);
    }

    private static Component createClickableMessage() {
        return Component.m_237113_((String)((String)welcomeMessage.get())).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)"[Click here]").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)clickableUrl.get())).m_131162_(Boolean.valueOf(true)).m_131148_(TextColor.m_131266_((int)65450))));
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("welcome_message");
        enabled = builder.comment("Enable or disable the welcome message").define("enabled", true);
        welcomeMessage = builder.comment("The message to be displayed when a player joins the game for the first time").define("text", (Object)"THANKS TO OUR SPONSORS, ZAP-HOSTING! Support Reggarf And Save BIG - USE CODE Reggarf-1047 FOR 20% OFF Your ORDER!");
        clickableUrl = builder.comment("The URL to be opened when the player clicks the link").define("url", (Object)"https://zap-hosting.com/reggarf");
        builder.pop();
        COMMON_SPEC = builder.build();
    }
}

