/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MobEffectItem
extends WearableArtifactItem {
    private final MobEffect mobEffect;
    private final int duration;
    protected final Supplier<Integer> amplifier;
    protected final Supplier<Boolean> isEnabled;

    public MobEffectItem(MobEffect mobEffect, Supplier<Boolean> isEnabled) {
        this(mobEffect, () -> 1, 40, isEnabled);
    }

    public MobEffectItem(MobEffect mobEffect, int duration, Supplier<Boolean> isEnabled) {
        this(mobEffect, () -> 1, duration, isEnabled);
    }

    public MobEffectItem(MobEffect mobEffect, Supplier<Integer> amplifier, int duration) {
        this(mobEffect, amplifier, duration, () -> true);
    }

    private MobEffectItem(MobEffect mobEffect, Supplier<Integer> amplifier, int duration, Supplier<Boolean> isEnabled) {
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.isEnabled = isEnabled;
    }

    @Override
    protected boolean hasNonCosmeticEffects() {
        return this.isEnabled.get() != false && this.amplifier.get() > 0;
    }

    public boolean isEffectActive(LivingEntity entity) {
        if (!this.isEnabled.get().booleanValue() || this.amplifier.get() == 0) {
            return false;
        }
        return this.findAllEquippedBy(entity).anyMatch(WearableArtifactItem::isActivated);
    }

    private int getAmplifier() {
        return this.amplifier.get() - 1;
    }

    protected int getDuration(LivingEntity entity) {
        return this.duration;
    }

    @Nullable
    protected LivingEntity getTarget(LivingEntity entity) {
        return entity;
    }

    protected boolean shouldShowIcon() {
        return false;
    }

    protected boolean shouldShowParticles() {
        return false;
    }

    protected int getUpdateInterval() {
        return 1;
    }

    @Override
    public void wornTick(LivingEntity entity, ItemStack stack) {
        LivingEntity target;
        if (this.isEffectActive(entity) && !entity.m_9236_().m_5776_() && (target = this.getTarget(entity)) != null && entity.f_19797_ % this.getUpdateInterval() == 0) {
            target.m_7292_(new MobEffectInstance(this.mobEffect, this.getDuration(target) - 1, this.getAmplifier(), false, this.shouldShowParticles(), this.shouldShowIcon()));
        }
    }

    @Override
    public void onUnequip(LivingEntity entity, ItemStack stack) {
        this.removeRemainingEffect(entity);
    }

    private void removeRemainingEffect(LivingEntity entity) {
        MobEffectInstance effectInstance;
        if (this.isEnabled.get().booleanValue() && !entity.m_9236_().m_5776_() && this.getTarget(entity) == entity && (effectInstance = entity.m_21124_(this.mobEffect)) != null && effectInstance.m_19564_() == this.getAmplifier() && !effectInstance.m_19572_() && effectInstance.m_19557_() < this.getDuration(entity)) {
            entity.m_21195_(this.mobEffect);
        }
    }

    @Override
    public void toggleItem(ServerPlayer player) {
        super.toggleItem(player);
        if (!this.isEffectActive((LivingEntity)player)) {
            this.removeRemainingEffect((LivingEntity)player);
        }
    }
}

