/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public interface Reward
extends CodecProvider<Reward> {
    public static final CodecMap<Reward> CODEC = new CodecMap("Gateway Reward");
    public static final Method dropFromLootTable = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7625_", (Class[])new Class[]{DamageSource.class, Boolean.TYPE});
    public static final MethodHandle DROP_LOOT = Reward.lootMethodHandle();

    public void generateLoot(ServerLevel var1, GatewayEntity var2, Player var3, Consumer<ItemStack> var4);

    public void appendHoverText(Consumer<MutableComponent> var1);

    public static void initSerializers() {
        Reward.register("stack", StackReward.CODEC);
        Reward.register("stack_list", StackListReward.CODEC);
        Reward.register("entity_loot", EntityLootReward.CODEC);
        Reward.register("loot_table", LootTableReward.CODEC);
        Reward.register("chanced", ChancedReward.CODEC);
        Reward.register("command", CommandReward.CODEC);
        Reward.register("experience", XpReward.CODEC);
        Reward.register("summon", SummonReward.CODEC);
    }

    private static void register(String id, Codec<? extends Reward> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    private static MethodHandle lootMethodHandle() {
        dropFromLootTable.setAccessible(true);
        try {
            return MethodHandles.lookup().unreflect(dropFromLootTable);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public record StackReward(ItemStack stack) implements Reward
    {
        public static Codec<StackReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.fieldOf("stack").forGetter(StackReward::stack)).apply((Applicative)inst, StackReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            list.accept(this.stack.m_41777_());
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"reward.gateways.stack", (Object[])new Object[]{this.stack.m_41613_(), this.stack.m_41786_()}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record StackListReward(List<ItemStack> stacks) implements Reward
    {
        public static Codec<StackListReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAdapter.CODEC.listOf().fieldOf("stacks").forGetter(StackListReward::stacks)).apply((Applicative)inst, StackListReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            this.stacks.forEach(s -> list.accept(s.m_41777_()));
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            for (ItemStack stack : this.stacks) {
                list.accept(Component.m_237110_((String)"reward.gateways.stack", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_()}));
            }
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record EntityLootReward(EntityType<?> type, @Nullable CompoundTag nbt, int rolls) implements Reward
    {
        public static Codec<EntityLootReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("entity").forGetter(EntityLootReward::type), (App)PlaceboCodecs.nullableField((Codec)NBTAdapter.EITHER_CODEC, (String)"nbt").forGetter(r -> Optional.ofNullable(r.nbt)), (App)PlaceboCodecs.nullableField((Codec)Codec.intRange((int)1, (int)Integer.MAX_VALUE), (String)"rolls", (Object)1).forGetter(EntityLootReward::rolls)).apply((Applicative)inst, (type, nbt, rolls) -> new EntityLootReward((EntityType<?>)type, nbt.orElse(null), (int)rolls)));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            try {
                ArrayList items = new ArrayList();
                Entity entity = this.type.m_20615_((Level)level);
                entity.getPersistentData().m_128379_("apoth.no_pinata", true);
                for (int i = 0; i < this.rolls; ++i) {
                    if (this.nbt != null) {
                        entity.m_20258_(this.nbt);
                    }
                    entity.m_7678_(summoner.m_20185_(), summoner.m_20186_(), summoner.m_20189_(), 0.0f, 0.0f);
                    DamageSource src = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_286979_), (Entity)summoner);
                    entity.m_6469_(src, 1.0f);
                    entity.captureDrops(items);
                    DROP_LOOT.invoke(entity, level.m_269111_().m_269075_(summoner), true);
                }
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                items.stream().map(ItemEntity::m_32055_).forEach(list);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"reward.gateways.entity", (Object[])new Object[]{this.rolls, Component.m_237115_((String)this.type.m_20675_())}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record LootTableReward(ResourceLocation table, int rolls, String desc) implements Reward
    {
        public static Codec<LootTableReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(LootTableReward::table), (App)PlaceboCodecs.nullableField((Codec)Codec.intRange((int)1, (int)Integer.MAX_VALUE), (String)"rolls", (Object)1).forGetter(LootTableReward::rolls), (App)Codec.STRING.fieldOf("desc").forGetter(LootTableReward::desc)).apply((Applicative)inst, LootTableReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            LootTable realTable = level.m_7654_().m_278653_().m_278676_(this.table);
            for (int i = 0; i < this.rolls; ++i) {
                LootParams.Builder ctx = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)gate.m_20318_(1.0f));
                ctx.m_287239_(summoner.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)summoner).m_287286_(LootContextParams.f_81463_, (Object)summoner.m_21205_());
                realTable.m_287195_(ctx.m_287235_(LootContextParamSets.f_81411_)).forEach(list);
            }
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"reward.gateways.loot_table", (Object[])new Object[]{this.rolls, this.desc.isEmpty() ? this.table : Component.m_237115_((String)this.desc)}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record ChancedReward(Reward reward, float chance) implements Reward
    {
        public static Codec<ChancedReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("reward").forGetter(ChancedReward::reward), (App)Codec.FLOAT.fieldOf("chance").forGetter(ChancedReward::chance)).apply((Applicative)inst, ChancedReward::new));
        protected static final DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            if (level.f_46441_.m_188501_() < this.chance) {
                this.reward.generateLoot(level, gate, summoner, list);
            }
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            this.reward.appendHoverText(c -> list.accept(Component.m_237110_((String)"reward.gateways.chance", (Object[])new Object[]{fmt.format(this.chance), c})));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record CommandReward(String command, String desc) implements Reward
    {
        public static Codec<CommandReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("command").forGetter(CommandReward::command), (App)Codec.STRING.fieldOf("desc").forGetter(CommandReward::desc)).apply((Applicative)inst, CommandReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            String realCmd = this.command.replace("<summoner>", summoner.m_36316_().getName());
            level.m_7654_().m_129892_().m_230957_(gate.m_20203_(), realCmd);
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237115_((String)this.desc));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record XpReward(int xp, int orbSize) implements Reward
    {
        public static Codec<XpReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("experience").forGetter(XpReward::xp), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"orb_size", (Object)5).forGetter(XpReward::orbSize)).apply((Applicative)inst, XpReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            for (int remaining = this.xp; remaining > 0; remaining -= this.orbSize) {
                level.m_7967_((Entity)new ExperienceOrb((Level)level, gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), this.orbSize));
            }
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"reward.gateways.experience", (Object[])new Object[]{this.xp}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }

    public record SummonReward(WaveEntity entity) implements Reward
    {
        public static Codec<SummonReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.fieldOf("entity").forGetter(SummonReward::entity)).apply((Applicative)inst, SummonReward::new));

        @Override
        public void generateLoot(ServerLevel level, GatewayEntity gate, Player summoner, Consumer<ItemStack> list) {
            for (int i = 0; i < this.entity.getCount(); ++i) {
                LivingEntity ent = this.entity.createEntity((Level)level);
                if (ent == null) continue;
                Vec3 pos = gate.getGateway().spawnAlgo().spawn(level, gate.m_20182_(), gate, (Entity)ent);
                ent.m_146884_(pos != null ? pos : gate.m_20182_());
                level.m_7967_((Entity)ent);
            }
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"reward.gateways.summon", (Object[])new Object[]{this.entity.getDescription()}));
        }

        public Codec<? extends Reward> getCodec() {
            return CODEC;
        }
    }
}

