/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderMysticStaffMahoujinEntity
extends EntityRenderer<MysticStaffMahoujinEntity> {
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");

    public RenderMysticStaffMahoujinEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(MysticStaffMahoujinEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(MysticStaffMahoujinEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderCircle(MysticStaffMahoujinEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float prevYaw;
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        int life = entity.getLife();
        float size = entity.getCircleSize();
        float yaw = entity.f_19857_ % 360.0f;
        float roll = entity.getRotationRoll();
        float pitch = entity.getRotationPitch();
        boolean renderBeam = entity.hasBeam();
        if (life < 20) {
            size = ((float)life + partialTicks) / 20.0f * size;
        }
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((prevYaw = entity.f_19859_ % 360.0f) < 0.0f) {
            prevYaw += 360.0f;
        }
        if (prevYaw - yaw > 300.0f) {
            yaw += 360.0f;
        }
        if (prevYaw - yaw < 300.0f && prevYaw - yaw > 0.0f) {
            prevYaw = yaw;
        }
        yaw = entity.f_19859_ + partialTicks * (yaw - prevYaw);
        matrix.m_85841_(size, size, size);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, true));
        int lightmapX = 240;
        int lightmapY = 240;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.setShader(GameRenderer::m_172835_);
        VertexConsumer bb = buf.m_6299_((RenderType)type);
        Matrix4f m = matrix.m_85850_().m_252922_();
        bb.m_252986_(m, -0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, -0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buf.m_109912_((RenderType)type);
        if (renderBeam) {
            float beamSize = MysticStaff.getBeamSize(entity, partialTicks);
            matrix.m_85841_(1.0f / size, 1.0f / size, 1.0f / size);
            matrix.m_85837_(-0.5, -0.5, -0.5);
            if (colors[1] < 0.26f) {
                colors[1] = (float)((double)colors[1] + 0.33);
            }
            matrix.m_85837_(0.5, 0.0, 0.5);
            RenderMysticStaffMahoujinEntity.renderBeamSegment(matrix, buf, (int)entity.getBeamOffset(), (int)entity.getBeamLength(), beamSize, (double)beamSize + 0.2, r, g, b);
        }
        matrix.m_85849_();
    }

    public static void renderBeamSegment(PoseStack matrix, MultiBufferSource.BufferSource buf, int yOffset, int height, double beamRadius, double glowRadius, float r, float g, float b) {
        CullWrappedRenderLayer beamtype1 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(beam, 0));
        CullWrappedRenderLayer beamtype2 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(beam, 1));
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        int lightmapX = 240;
        int lightmapY = 240;
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, (double)(-yOffset), 90.0f, (float)Math.max(0.0, beamRadius - (double)0.1f), (float)height, 64, lightmapX, lightmapY, 1.0f, 1.0f, 1.0f, 0.99f, beamtype1);
        buf.m_109912_((RenderType)beamtype1);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, (double)(-yOffset), 90.0f, (float)glowRadius, (float)height, 64, lightmapX, lightmapY, r, g, b, 0.3f, beamtype2);
        buf.m_109912_((RenderType)beamtype2);
        RenderUtils.rotateQ(-180.0f, 1.0f, 0.0f, 0.0f, matrix);
    }
}

