/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderGandrEntity
extends EntityRenderer<GandrEntity> {
    public RenderGandrEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(GandrEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(GandrEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderGandr(GandrEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float maxsize = 0.1f;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        float r2 = colors[4];
        float g2 = colors[5];
        float b2 = colors[6];
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        RenderUtils.rotateQ(-entity.f_19857_, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(entity.f_19858_, 1.0f, 0.0f, 0.0f, matrix);
        float liferatio = maxsize * (float)entity.getLife() / entity.getGrowingLife();
        float liferatioinv = maxsize;
        liferatio = Math.min(maxsize, liferatio);
        liferatioinv = Math.max(0.0f, liferatioinv);
        CullWrappedRenderLayer sphere1 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 0));
        CullWrappedRenderLayer sphere2 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 1));
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        matrix.m_85841_(1.6f, 1.6f, 1.6f);
        if (entity.getFired()) {
            float firedProgress = (float)entity.ticksSinceFired / (float)entity.firedProgressLife;
            firedProgress = Math.min(1.0f, firedProgress);
            matrix.m_85841_(1.0f - 0.2f * firedProgress, 1.0f - 0.2f * firedProgress, 1.0f + 0.4f * firedProgress);
        } else {
            double yshake;
            double xshake;
            float ringrot;
            if ((float)entity.getLife() < entity.getGrowingLife()) {
                ringrot = entity.getLife();
                xshake = 0.0;
                yshake = 0.0;
            } else {
                xshake = Math.random() * (double)0.003f - (double)0.0015f;
                yshake = Math.random() * (double)0.003f - (double)0.0015f;
                ringrot = entity.getGrowingLife();
            }
            matrix.m_85836_();
            matrix.m_85837_(xshake, yshake, (double)-0.15f);
            CullWrappedRenderLayer ring1 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.runes, 7));
            RenderUtils.rotateQ(90.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(ringrot, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 0.0f, 0.2f - 0.001f * ringrot, 0.05f, 64, 240, 240, r, g, b, 1.0f, ring1);
            buf.m_109912_((RenderType)ring1);
            matrix.m_85849_();
        }
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, liferatio * 0.9f, 32, 240, 240, r2, g2, b2, 1.0f, sphere1);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, liferatio * 1.1f, 32, 240, 240, r, g, b, 0.14f, sphere2);
        buf.m_109912_((RenderType)sphere1);
        buf.m_109912_((RenderType)sphere2);
        long time = ClientHandler.clientTickCounter;
        float repeat = 200.0f;
        float progress = (float)time % repeat / repeat;
        if (entity.inited) {
            float[] progressStarts = entity.progressstarts;
            float[] progressEnds = entity.progressends;
            for (int j = 0; j < entity.swirls; ++j) {
                float thisProgress;
                if (!RenderGandrEntity.progressInRange(progress, progressStarts[j], progressEnds[j])) continue;
                CullWrappedRenderLayer arc1 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, 2));
                CullWrappedRenderLayer arc2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.beam, 3));
                if (progressStarts[j] < progressEnds[j]) {
                    thisProgress = (progress - progressStarts[j]) / (progressEnds[j] - progressStarts[j]);
                } else {
                    float range = progressEnds[j] + 1.0f - progressStarts[j];
                    thisProgress = progress < progressEnds[j] ? (progress + 1.0f - progressStarts[j]) / range : (progress - progressStarts[j]) / range;
                }
                float progressFront = thisProgress + 0.7f;
                float progressBack = thisProgress;
                float angle = entity.angles[j];
                matrix.m_85836_();
                if (!entity.getFired()) {
                    RenderUtils.rotateQ(entity.angles[j], 0.0f, 1.0f, 0.0f, matrix);
                    RenderUtils.rotateQ(entity.angles[(j + 1) % entity.swirls], 1.0f, 0.0f, 0.0f, matrix);
                    RenderGandrEntity.renderPartialArcSpiral(matrix, (MultiBufferSource)buf, liferatioinv * 0.2f, 90.0f, liferatioinv * 1.8f, liferatioinv * 0.5f, 64, 240, 240, r, g, b, 0.7f, arc1, progressFront, progressBack, liferatio * 0.9f);
                } else {
                    progressFront = 1.0f - thisProgress * 0.55f;
                    progressBack = 1.0f - thisProgress * 0.55f - 0.1f;
                    RenderUtils.rotateQ(-90.0f, 0.0f, 1.0f, 0.0f, matrix);
                    RenderUtils.rotateQ(entity.angles[j], 1.0f, 0.0f, 0.0f, matrix);
                    RenderGandrEntity.renderPartialArcSpiral(matrix, (MultiBufferSource)buf, liferatioinv * 0.2f, 90.0f, liferatioinv * 1.8f, liferatioinv * 0.5f, 64, 240, 240, r, g, b, 0.5f, arc1, progressFront, progressBack, liferatio * 0.9f);
                    RenderUtils.rotateQ(entity.angles[(j + 1) % entity.swirls], 1.0f, 0.0f, 0.0f, matrix);
                    RenderGandrEntity.renderPartialArcSpiral(matrix, (MultiBufferSource)buf, liferatioinv * 0.2f, 90.0f, liferatioinv * 1.8f, liferatioinv * 0.5f, 64, 240, 240, r, g, b, 0.5f, arc2, progressFront, progressBack, liferatio * 0.9f);
                }
                matrix.m_85849_();
                buf.m_109912_((RenderType)arc1);
            }
        }
        matrix.m_85849_();
    }

    public static boolean progressInRange(float p, float s, float e) {
        if (s < e) {
            return p > s && p < e;
        }
        return p > s || p < e;
    }

    public static RenderType renderPartialArcSpiral(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float pf, float pb, float innerradius) {
        matrix.m_85836_();
        Matrix4f positionMatrix = matrix.m_85850_().m_252922_();
        VertexConsumer bb = buffer.m_6299_(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double h2 = height;
        double r2 = radius;
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double offset = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = 0.0f;
        int i = (int)((float)num_segments * pb);
        while ((float)i < Math.min((float)num_segments * pf + 1.0f, (float)(num_segments + 1))) {
            r2 = innerradius + (radius - innerradius) * ((float)(num_segments - i) / (float)num_segments);
            h2 = height * ((float)(num_segments - i) / (float)num_segments);
            p = r2 + h2 * Math.cos(EffectUtil.toRad(flatness));
            q = h2 * Math.sin(EffectUtil.toRad(flatness));
            offset = ((double)height - q) / 2.0;
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.m_252986_(positionMatrix, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
                bb.m_252986_(positionMatrix, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
            }
            double tt = (double)i * theta;
            x = -r2 * Math.sin(tt);
            y = cy - offset;
            z = r2 * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q - offset;
            zb = p * Math.cos(tt);
            bb.m_252986_(positionMatrix, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(texx, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_252986_(positionMatrix, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(texx, 1.0f).m_7120_(lx, ly).m_5752_();
            ++i;
        }
        matrix.m_85849_();
        return type;
    }
}

