/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import stepsword.mahoutsukai.entity.mahoujin.BeamProjectileEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderBeamProjectileEntity
extends EntityRenderer<BeamProjectileEntity> {
    static RenderType sphere1 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 0));
    static RenderType sphere2 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 1));
    static RenderType sphere3 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 2));
    static RenderType sphere4 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.beam, 3));
    static RenderType beam1 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(RenderUtils.beam, 4));
    static RenderType beam2 = new CullWrappedRenderLayer(MahoujinRenderType.createBeamRenderType(RenderUtils.beam, 5));

    public RenderBeamProjectileEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(BeamProjectileEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(BeamProjectileEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderBeamProjectile(BeamProjectileEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        float r2 = colors[4];
        float g2 = colors[5];
        float b2 = colors[6];
        float a2 = colors[7];
        float radius = entity.getRadius();
        float length = entity.getLength();
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        RenderUtils.rotateQ(entity.getRotationYaw(), 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(entity.getRotationPitch(), 1.0f, 0.0f, 0.0f, matrix);
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        float buffer = 0.02f;
        float factor = Math.max(4.0f, 4.0f * length * length);
        matrix.m_85841_(1.0f, factor, 1.0f);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius - buffer, 32, 240, 240, r2, g2, b2, a2, sphere1, 0.52f);
        matrix.m_252880_(0.0f, -length / factor, 0.0f);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius - buffer, 32, 240, 240, r2, g2, b2, a2, sphere3, 0.52f);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        matrix.m_252880_(0.0f, length / factor, 0.0f);
        matrix.m_85841_(1.0f, 1.0f / factor, 1.0f);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, Math.max(0.0f, radius - buffer), length, 64, 240, 240, r2, g2, b2, a2, beam1);
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 90.0f, radius, length, 64, 240, 240, r, g, b, a, beam2);
        matrix.m_85841_(1.0f, factor, 1.0f);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius, 32, 240, 240, r, g, b, a, sphere2, 0.52f);
        matrix.m_252880_(0.0f, -length / factor, 0.0f);
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.renderSphere(matrix, (MultiBufferSource)buf, radius, 32, 240, 240, r, g, b, a, sphere4, 0.52f);
        buf.m_109912_(sphere1);
        buf.m_109912_(sphere3);
        buf.m_109912_(beam1);
        buf.m_109912_(beam2);
        buf.m_109912_(sphere4);
        buf.m_109912_(sphere2);
        matrix.m_85849_();
    }
}

