/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ProjectionSpellEffect {
    public static boolean projection(Player caster, CompoundTag weaponNBT) {
        int setDamage = MTConfig.PROJECTION_DURABILITY_FACTOR;
        if (weaponNBT != null) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)weaponNBT).m_41777_();
            stack.m_41764_(1);
            if (stack.m_41763_()) {
                if (MTConfig.PROJECTION_DURABILITY_FLAT) {
                    setDamage = stack.m_41776_() - setDamage;
                }
                stack.m_41721_(setDamage);
                stack = ProjectionSpellEffect.removeDisallowedEnchants(stack);
                StrengtheningSpellEffect.reduceStrengthened(stack, StrengtheningSpellEffect.getStrengthened(stack));
                ProjectionSpellEffect.setProjected(stack);
                return caster.m_36356_(stack);
            }
        }
        return false;
    }

    public static void setProjected(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128379_("MAHOUTSUKAI_PROJECTION", true);
        s.m_41751_(nbt);
    }

    public static boolean getProjected(ItemStack s) {
        CompoundTag nbt = s.m_41783_();
        return nbt != null && nbt.m_128441_("MAHOUTSUKAI_PROJECTION") && nbt.m_128471_("MAHOUTSUKAI_PROJECTION");
    }

    public static void projectionUpdateAnvil(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if ((ProjectionSpellEffect.getProjected(left) || ProjectionSpellEffect.getProjected(right)) && MTConfig.PROJECTION_ANVIL_CANCEL) {
            event.setCanceled(true);
        }
    }

    public static void projectionRepairAnvil(AnvilRepairEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if ((ProjectionSpellEffect.getProjected(left) || ProjectionSpellEffect.getProjected(right)) && !MTConfig.PROJECTION_ANVIL_CANCEL) {
            Map enchs = EnchantmentHelper.m_44831_((ItemStack)event.getOutput());
            Map enchsleft = EnchantmentHelper.m_44831_((ItemStack)left);
            Map enchsright = EnchantmentHelper.m_44831_((ItemStack)right);
            for (Enchantment e : enchs.keySet()) {
                if (!enchsleft.containsKey(e) || !enchsright.containsKey(e)) continue;
                Integer m = (Integer)enchsleft.get(e);
                Integer k = (Integer)enchsright.get(e);
                enchs.put(e, Math.min(m, k));
            }
            EnchantmentHelper.m_44865_((Map)enchs, (ItemStack)event.getOutput());
        }
    }

    public static CompoundTag memorize(Player caster) {
        if (caster != null) {
            Entity e = Utils.selectEntityNearCursor(caster, MTConfig.GLOBAL_LOOK_RANGE, caster.m_9236_(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_PROJECTION, a, caster), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_PROJECTION));
            CompoundTag ret = new CompoundTag();
            if (e instanceof LivingEntity) {
                Iterable lst = e.m_6167_();
                for (ItemStack tmp : lst) {
                    if (!ProjectionSpellEffect.canProject(tmp)) continue;
                    tmp.m_41739_(ret);
                    return ret;
                }
            } else if (e instanceof ItemEntity) {
                if (ProjectionSpellEffect.canProject(((ItemEntity)e).m_32055_())) {
                    ((ItemEntity)e).m_32055_().m_41739_(ret);
                    return ret;
                }
            } else if (e instanceof ItemFrame) {
                if (ProjectionSpellEffect.canProject(((ItemFrame)e).m_31822_())) {
                    ((ItemFrame)e).m_31822_().m_41739_(ret);
                    return ret;
                }
            } else if (e instanceof WeaponProjectileEntity) {
                if (ProjectionSpellEffect.canProject(((WeaponProjectileEntity)e).getStack())) {
                    ((WeaponProjectileEntity)e).getStack().m_41739_(ret);
                    return ret;
                }
            } else if (e instanceof ThrownTrident && ProjectionSpellEffect.canProject(((ThrownTrident)e).f_37555_)) {
                ((ThrownTrident)e).f_37555_.m_41739_(ret);
                return ret;
            }
        }
        return null;
    }

    public static boolean canProject(ItemStack stack) {
        Item tmpi = stack.m_41720_();
        boolean ret = tmpi instanceof BowItem || tmpi instanceof SwordItem || tmpi instanceof AxeItem || tmpi instanceof HoeItem || tmpi instanceof ShovelItem || tmpi instanceof PickaxeItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof TridentItem || tmpi instanceof CrossbowItem;
        return ret && !ProjectionSpellEffect.disallowed(tmpi) && stack.m_41763_() || EffectUtil.inItemBlacklist(tmpi, MTConfig.PROJECTION_EXPLICIT_WHITELIST);
    }

    public static boolean disallowed(Item tmpi) {
        if (Utils.getRegistryKey(tmpi) != null) {
            HashSet<? extends String> disallowed = new HashSet<String>(MTConfig.PROJECTION_BLACKLIST);
            if (MTConfig.PROJECTION_IS_BLACKLIST) {
                return disallowed.contains(Utils.getRegistryName(tmpi)) || disallowed.contains(Utils.getRegistryKey(tmpi).m_135827_());
            }
            return !disallowed.contains(Utils.getRegistryName(tmpi)) && !disallowed.contains(Utils.getRegistryKey(tmpi).m_135827_());
        }
        return false;
    }

    public static ItemStack removeDisallowedEnchants(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        HashSet<? extends String> disallowed = new HashSet<String>(MTConfig.PROJECTION_ENCHANTMENT_BLACKLIST);
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)copy);
        map = map.entrySet().stream().filter(a -> !disallowed.contains(Utils.getRegistryName((Enchantment)a.getKey()))).collect(Collectors.toMap(m -> (Enchantment)m.getKey(), m -> (Integer)m.getValue()));
        EnchantmentHelper.m_44865_(map, (ItemStack)copy);
        return copy;
    }
}

