/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ClientRecipeHelper {
    private ClientRecipeHelper() {
    }

    public static Optional<? extends Recipe<?>> getRecipeByKey(ResourceLocation recipeKey) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        if (world == null) {
            return Optional.empty();
        }
        return world.m_7465_().m_44043_(recipeKey);
    }

    public static <T extends Recipe<?>, U extends Recipe<?>> List<T> getAndTransformAvailableRecipes(Set<ResourceLocation> recipeKeys, Class<U> originalRecipeClass, Function<U, T> transformRecipe) {
        ArrayList ret = new ArrayList();
        recipeKeys.forEach(key -> ClientRecipeHelper.getRecipeByKey(key).ifPresent(r -> {
            if (originalRecipeClass.isInstance(r)) {
                ret.add((Recipe)transformRecipe.apply((Recipe)originalRecipeClass.cast(r)));
            }
        }));
        return ret;
    }

    public static <T extends Recipe<?>, U extends Recipe<?>> List<T> getAndTransformAvailableItemGroupRecipes(Set<ResourceLocation> recipeKeys, Class<U> originalRecipeClass, Function<U, List<T>> getTransformedRecipes) {
        ArrayList ret = new ArrayList();
        recipeKeys.forEach(key -> ClientRecipeHelper.getRecipeByKey(key).ifPresent(r -> {
            if (originalRecipeClass.isInstance(r)) {
                ret.addAll((Collection)getTransformedRecipes.apply((Recipe)originalRecipeClass.cast(r)));
            }
        }));
        return ret;
    }

    public static CraftingRecipe copyShapedRecipe(ShapedRecipe recipe) {
        return new ShapedRecipe(recipe.m_6423_(), "", recipe.m_245232_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), recipe.m_7527_(), RecipeUtil.getResultItem((Recipe)recipe));
    }

    public static CraftingRecipe copyShapelessRecipe(ShapelessRecipe recipe) {
        return new ShapelessRecipe(recipe.m_6423_(), "", recipe.m_245232_(), RecipeUtil.getResultItem((Recipe)recipe), recipe.m_7527_());
    }

    public static <C extends Container> ItemStack assemble(Recipe<C> recipe, C container) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_5874_(container, registryAccess);
    }
}

