/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismmoremachine.common.tile.prefab;

import com.fxd927.mekanismmoremachine.common.tile.prefab.MMTileEntityRecipeMachine;
import java.util.List;
import mekanism.api.Upgrade;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class MMTileEntityProgressMachine<RECIPE extends MekanismRecipe>
extends MMTileEntityRecipeMachine<RECIPE> {
    public int ticksRequired;
    protected int baseTicksRequired;
    private int operatingTicks;

    protected MMTileEntityProgressMachine(IBlockProvider blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, int baseTicksRequired) {
        super(blockProvider, pos, state, errorTypes);
        this.ticksRequired = this.baseTicksRequired = baseTicksRequired;
    }

    public double getScaledProgress() {
        return (double)this.getOperatingTicks() / (double)this.ticksRequired;
    }

    @ComputerMethod(nameOverride="getRecipeProgress")
    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    protected void setOperatingTicks(int ticks) {
        this.operatingTicks = ticks;
    }

    @ComputerMethod
    public int getTicksRequired() {
        return this.ticksRequired;
    }

    @Override
    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getOperatingTicks();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.operatingTicks = nbt.m_128451_("progress");
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128405_("progress", this.getOperatingTicks());
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)this.baseTicksRequired);
        }
    }

    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableInt.create(this::getOperatingTicks, this::setOperatingTicks));
        container.track((ISyncableData)SyncableInt.create(this::getTicksRequired, value -> {
            this.ticksRequired = value;
        }));
    }
}

