/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.network.FriendlyByteBuf;

public class DimletClientHelper {
    public static long dimletListAge = 0L;
    public static List<DimletWithInfo> dimlets = new ArrayList<DimletWithInfo>();

    public static void setDimletsOnGui(List<DimletWithInfo> dimlets) {
        DimletClientHelper.dimlets = dimlets;
        ++dimletListAge;
    }

    public record DimletWithInfo(DimletKey dimlet, boolean craftable) implements Comparable<DimletWithInfo>
    {
        @Override
        public int compareTo(DimletWithInfo o) {
            return this.dimlet().compareTo(o.dimlet());
        }

        public static class Serializer
        implements ISerializer<DimletWithInfo> {
            public Function<FriendlyByteBuf, DimletWithInfo> getDeserializer() {
                return buf -> {
                    short idx = buf.readShort();
                    DimletType type = DimletType.values()[idx];
                    String key = buf.m_130136_(Short.MAX_VALUE);
                    DimletKey dimlet1 = new DimletKey(type, key);
                    boolean craftable1 = buf.readBoolean();
                    return new DimletWithInfo(dimlet1, craftable1);
                };
            }

            public BiConsumer<FriendlyByteBuf, DimletWithInfo> getSerializer() {
                return (buf, info) -> {
                    DimletKey dimlet1 = info.dimlet();
                    buf.writeShort(dimlet1.type().ordinal());
                    buf.m_130070_(dimlet1.key());
                    buf.writeBoolean(info.craftable());
                };
            }
        }
    }
}

