/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.util;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class VoxelShapeBuilder {
    private VoxelShape leftShape;
    private VoxelShape lastOrShape;

    private VoxelShapeBuilder() {
    }

    public static VoxelShapeBuilder builder() {
        return new VoxelShapeBuilder();
    }

    public static VoxelShapeBuilder fromShapes(VoxelShape ... shapes) {
        VoxelShapeBuilder builder = new VoxelShapeBuilder();
        for (VoxelShape shape : shapes) {
            builder.shape(shape);
        }
        return builder;
    }

    public VoxelShapeBuilder shape(VoxelShape shape) {
        if (this.leftShape == null) {
            this.leftShape = shape;
        } else {
            VoxelShape newShape = Shapes.m_83110_((VoxelShape)this.leftShape, (VoxelShape)shape);
            this.lastOrShape = this.lastOrShape != null ? Shapes.m_83110_((VoxelShape)this.lastOrShape, (VoxelShape)newShape) : newShape;
            this.leftShape = null;
        }
        return this;
    }

    public VoxelShapeBuilder cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
        VoxelShape shape = Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        return this.shape(shape);
    }

    public VoxelShape build() {
        return this.lastOrShape;
    }
}

