/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.CommonMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;

public final class CommonCollect {
    public static <T> Optional<T> getRandomElementFrom(Collection<T> collection) {
        return CommonCollect.getRandomElementFrom(collection, CommonMath.RANDOM);
    }

    public static <T> Optional<T> getRandomElementFrom(Collection<T> collection, Random random) {
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        Object[] elements = collection.toArray();
        int index = CommonMath.Random.between(0, elements.length - 1, random);
        return Optional.ofNullable(elements[index]);
    }

    public static class WeightedList<T extends IWeighted> {
        protected List<T> list = new ArrayList<T>();
        protected long totalWeight = 0L;

        @SafeVarargs
        public static <T extends IWeighted> WeightedList<T> withElements(T ... elements) {
            WeightedList<T> list = new WeightedList<T>();
            for (T element : elements) {
                list.add(element);
            }
            return list;
        }

        public long getTotalWeight() {
            return this.totalWeight;
        }

        public void clear() {
            this.list.clear();
            this.totalWeight = 0L;
        }

        public boolean add(T element) {
            boolean result = this.list.add(element);
            if (result) {
                this.totalWeight += (long)element.getWeight();
            }
            return result;
        }

        public boolean remove(T element) {
            boolean result = this.list.remove(element);
            if (result) {
                this.totalWeight -= (long)element.getWeight();
            }
            return result;
        }

        public boolean contains(T element) {
            return this.list.contains(element);
        }

        public int size() {
            return this.list.size();
        }

        public List<T> getElements() {
            return Collections.unmodifiableList(this.list);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Optional<T> getRandom() {
            return this.getRandom(CommonMath.RANDOM);
        }

        public Optional<T> getRandom(Random random) {
            if (this.list.isEmpty() || this.getTotalWeight() <= 0L) {
                return Optional.empty();
            }
            long weight = CommonMath.getFloor(random.nextDouble() * (double)this.getTotalWeight());
            for (IWeighted elem : this.list) {
                if ((weight -= (long)elem.getWeight()) >= 0L) continue;
                return Optional.of(elem);
            }
            return Optional.empty();
        }

        @Deprecated
        public Optional<T> getRandom(Supplier<Double> randomValue) {
            if (this.list.isEmpty() || this.getTotalWeight() <= 0L) {
                return Optional.empty();
            }
            long weight = CommonMath.getFloor(randomValue.get() * (double)this.getTotalWeight());
            for (IWeighted elem : this.list) {
                if ((weight -= (long)elem.getWeight()) >= 0L) continue;
                return Optional.of(elem);
            }
            return Optional.empty();
        }
    }

    public static interface IWeighted {
        public int getWeight();
    }

    public static class BlackWhiteList<E> {
        protected final List<E> blackList;
        protected final List<E> whiteList;

        public BlackWhiteList(List<E> black, List<E> white) {
            this.blackList = black;
            this.whiteList = white;
        }

        public boolean isAllowed(E element) {
            boolean valid = false;
            valid = this.whiteList.isEmpty() ? !this.blackList.contains(element) : this.whiteList.contains(element);
            return valid;
        }

        public boolean isEmpty() {
            return this.blackList.isEmpty() && this.whiteList.isEmpty();
        }
    }
}

