/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file.serializers;

import java.util.Collection;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.config.IJeiConfigValueSerializer;
import mezz.jei.common.config.file.serializers.DeserializeResult;

public class TypedIngredientSerializer
implements IJeiConfigValueSerializer<ITypedIngredient<?>> {
    private static final String SEPARATOR = "&";
    private final IIngredientManager ingredientManager;

    public TypedIngredientSerializer(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    @Override
    public String serialize(ITypedIngredient<?> value) {
        IIngredientType<?> type = value.getType();
        String typeUid = type.getUid();
        String uid = TypedIngredientSerializer.getUid(this.ingredientManager, value);
        return typeUid + SEPARATOR + uid;
    }

    public static <T> String getUid(IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        T ingredient = typedIngredient.getIngredient();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredient);
        return ingredientHelper.getUniqueId(ingredient, UidContext.Recipe);
    }

    @Override
    public IJeiConfigValueSerializer.IDeserializeResult<ITypedIngredient<?>> deserialize(String string) {
        String[] parts = string.split(SEPARATOR);
        if (parts.length != 2) {
            String error = "string must be two uids, separated by '&': " + string;
            return new DeserializeResult<Object>(null, error);
        }
        String typeUid = parts[0];
        String uid = parts[1];
        Optional<IIngredientType<?>> ingredientTypeForUid = this.ingredientManager.getIngredientTypeForUid(typeUid);
        if (ingredientTypeForUid.isEmpty()) {
            String error = "no ingredient type was found for uid: " + typeUid;
            return new DeserializeResult<Object>(null, error);
        }
        IIngredientType<?> ingredientType = ingredientTypeForUid.get();
        Optional<ITypedIngredient<?>> ingredient = this.ingredientManager.getTypedIngredientByUid(ingredientType, uid);
        if (ingredient.isEmpty()) {
            String error = "no ingredient was found for uid: " + uid;
            return new DeserializeResult<Object>(null, error);
        }
        return new DeserializeResult(ingredient.get());
    }

    @Override
    public boolean isValid(ITypedIngredient<?> value) {
        return true;
    }

    @Override
    public Optional<Collection<ITypedIngredient<?>>> getAllValidValues() {
        return Optional.empty();
    }

    @Override
    public String getValidValuesDescription() {
        return "";
    }
}

