/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.ClientBaseHelper;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder;
import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.FlowLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;

class SensorsList<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>
extends Panel {
    private static final Component DIRECTION_INPUT = TextHelper.translatable("gui.zerocore.base.redstone.sensortype.input", (NonNullFunction<MutableComponent, MutableComponent>)((NonNullFunction)ClientBaseHelper::formatAsInfo));
    private static final Component DIRECTION_OUTPUT = TextHelper.translatable("gui.zerocore.base.redstone.sensortype.output", (NonNullFunction<MutableComponent, MutableComponent>)((NonNullFunction)ClientBaseHelper::formatAsInfo));
    private static final int HORIZONTAL_MARGIN = 3;
    private static final int CONTROL_SPACING = 4;
    private final NonNullConsumer<SensorType> _onSensorChangedCallback;
    private final Map<SensorType, SwitchPictureButton> _buttons;
    private SwitchPictureButton _activeButton;

    public SensorsList(SensorGroupPanelBuilder<Reader, SensorType> builder, int columns, String sensorsListLabelKey, NonNullConsumer<SensorType> onSensorChangedCallback) {
        super(builder.getGui(), "sensorsList");
        this._onSensorChangedCallback = onSensorChangedCallback;
        this._buttons = new Object2ObjectArrayMap(32);
        this._activeButton = null;
        int listWidth = SensorsList.computeWidth(columns);
        this.setPadding(0);
        this.setLayoutEngine((ILayoutEngine)((FlowLayoutEngine)((FlowLayoutEngine)new FlowLayoutEngine().setZeroMargins()).setHorizontalMargin(3)).setControlsSpacing(4));
        this.setDesiredDimension(listWidth, builder.getHeight());
        Label label = new Label(builder.getGui(), "sensorListLabel", (Component)TextHelper.translatable(sensorsListLabelKey));
        label.setPadding(0);
        label.setAutoSize(false);
        label.setDesiredDimension(listWidth, 10);
        this.addControl((IControl)label);
        for (SensorGroupPanelBuilder.BehaviorGroupBuilder groupBuilder : builder.getGroupsBuilders()) {
            if (null == groupBuilder) {
                this.addSeparator();
                continue;
            }
            this.addSensor(groupBuilder);
        }
    }

    static int computeWidth(int columns) {
        return 3 + columns * 18 + (columns - 1) * 4 + 3;
    }

    public void setSettings(SensorSetting setting) {
        this.resetSettings();
        SwitchPictureButton button = this._buttons.get(((AbstractSensorSetting)setting).Sensor);
        if (null != button) {
            button.setActive(true);
        }
    }

    public void resetSettings() {
        if (null != this._activeButton) {
            this._activeButton.setActive(false);
        }
    }

    private void addSensor(SensorGroupPanelBuilder.BehaviorGroupBuilder builder) {
        Object sensor = builder.getSensor();
        SwitchPictureButton button = new SwitchPictureButton(this.getGui(), ((Enum)sensor).name(), false, "sensortype");
        button.setTag(sensor);
        button.setTooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle(((ISensorType)sensor).getNameTranslationKey()).addText(((ISensorType)sensor).isInput() ? DIRECTION_INPUT : DIRECTION_OUTPUT).addEmptyLine().addTranslatable(((ISensorType)sensor).getDescriptionTranslationKey()));
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)button, ButtonState.Default, builder.getButtonOffSprite());
        ClientBaseHelper.setButtonSpritesAndOverlayForState((AbstractButtonControl)button, ButtonState.Active, builder.getButtonOnSprite());
        button.setDesiredDimension(18, 18);
        button.setBackground(BaseIcons.ImageButtonBackground.get());
        button.enablePaintBlending(true);
        button.setPadding(1);
        button.Activated.subscribe(btn -> btn.getTag().ifPresent(newSensor -> {
            this._activeButton = btn;
            this._onSensorChangedCallback.accept(newSensor);
        }));
        this.addControl((IControl)button);
        this._buttons.put(sensor, button);
    }

    private void addSeparator() {
        Static separator = new Static(this.getGui(), this.getDesiredDimension(DesiredDimension.Width), 1);
        separator.setColor(Colour.BLACK);
        this.addControl((IControl)separator);
    }
}

