/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.repack.bml.utils.text;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class TextUtil {
    public static String capitaliseFirstLetterFully(String text) {
        if (TextUtil.isNullOrEmpty(text)) {
            return "";
        }
        return Arrays.stream(text.split(" ")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String text) {
        return !TextUtil.isNullOrEmpty(text);
    }

    public static String getFormattedText(Component textComponent) {
        StringBuilder stringbuilder = new StringBuilder();
        String s = "";
        Iterator iterator = TextUtil.stream(textComponent).iterator();
        while (iterator.hasNext()) {
            Component itextcomponent = (Component)iterator.next();
            String s1 = itextcomponent.getString();
            if (s1.isEmpty()) continue;
            String s2 = TextUtil.getFormattingCode(itextcomponent.m_7383_());
            if (!s2.equals(s)) {
                if (!s.isEmpty()) {
                    stringbuilder.append(ChatFormatting.RESET);
                }
                stringbuilder.append(s2);
                s = s2;
            }
            stringbuilder.append(s1);
        }
        if (!s.isEmpty()) {
            stringbuilder.append(ChatFormatting.RESET);
        }
        return stringbuilder.toString();
    }

    private static String getFormattingCode(Style style) {
        if (style.m_131179_()) {
            return "";
        }
        StringBuilder stringbuilder = new StringBuilder();
        if (style.m_131135_() != null) {
            String name = style.m_131135_().f_131258_;
            if (TextUtil.isNotNullOrEmpty(name)) {
                stringbuilder.append(ChatFormatting.m_126657_((String)name));
            } else {
                stringbuilder.append((Object)style.m_131135_().m_131274_());
            }
        }
        if (style.m_131154_()) {
            stringbuilder.append(ChatFormatting.BOLD);
        }
        if (style.m_131161_()) {
            stringbuilder.append(ChatFormatting.ITALIC);
        }
        if (style.m_131171_()) {
            stringbuilder.append(ChatFormatting.UNDERLINE);
        }
        if (style.m_131176_()) {
            stringbuilder.append(ChatFormatting.OBFUSCATED);
        }
        if (style.m_131168_()) {
            stringbuilder.append(ChatFormatting.STRIKETHROUGH);
        }
        return stringbuilder.toString();
    }

    private static Stream<Component> stream(Component textComponent) {
        return Streams.concat((Stream[])new Stream[]{Stream.of(textComponent), textComponent.m_7360_().stream().flatMap(i -> TextUtil.stream(i))});
    }
}

