/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.tabstats.common.events;

import com.black_dog20.tabstats.Config;
import com.black_dog20.tabstats.TabStats;
import com.black_dog20.tabstats.common.network.PacketHandler;
import com.black_dog20.tabstats.common.network.packets.PacketPlayers;
import com.black_dog20.tabstats.common.utils.PlayerStat;
import com.black_dog20.tabstats.repack.bml.utils.file.FileUtil;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="tabstats")
public class ServerEvents {
    private static ConcurrentHashMap<String, Long> LAST_SEEN_MAP = new ConcurrentHashMap();
    private static Map<UUID, PlayerStat> playerStatMap = new ConcurrentHashMap<UUID, PlayerStat>();
    private static int ticks = 0;
    private static int backupTicks = 0;

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_6846_().m_11309_() == 0) {
            ticks = 0;
            return;
        }
        if (ticks % (Integer)Config.REFRESH_TICKS.get() == 0) {
            Map<UUID, ServerStatsCounter> serverStatsCounterMap = ServerEvents.getPlayerStats(server);
            List onlinePlayers = server.m_6846_().m_11314_().stream().map(Entity::m_20148_).collect(Collectors.toList());
            for (Map.Entry playerEntry : UsernameCache.getMap().entrySet()) {
                UUID uuid = (UUID)playerEntry.getKey();
                String name = (String)playerEntry.getValue();
                if (onlinePlayers.contains(uuid)) {
                    ServerPlayer serverPlayer = server.m_6846_().m_11259_(uuid);
                    if (serverPlayer != null) {
                        playerStatMap.put(uuid, PlayerStat.from(uuid, name, (StatsCounter)serverPlayer.m_8951_(), true));
                        continue;
                    }
                    ServerEvents.addNotOnlinePlayer(serverStatsCounterMap, uuid, name);
                    continue;
                }
                ServerEvents.addNotOnlinePlayer(serverStatsCounterMap, uuid, name);
            }
            PacketHandler.sendToAll(new PacketPlayers(playerStatMap));
            ticks = 1;
            return;
        }
        ++ticks;
    }

    private static void addNotOnlinePlayer(Map<UUID, ServerStatsCounter> serverStatsCounterMap, UUID uuid, String name) {
        if (serverStatsCounterMap.containsKey(uuid)) {
            playerStatMap.put(uuid, PlayerStat.from(uuid, name, (StatsCounter)serverStatsCounterMap.get(uuid), false));
        } else {
            playerStatMap.put(uuid, new PlayerStat(uuid, name, -1, -1, -1, -1L));
        }
    }

    private static Map<UUID, ServerStatsCounter> getPlayerStats(MinecraftServer server) {
        File folder = server.m_129843_(LevelResource.f_78175_).toFile();
        File[] listOfFiles = folder.listFiles();
        return Optional.ofNullable(listOfFiles).map(Arrays::asList).orElse(Collections.emptyList()).stream().collect(Collectors.toConcurrentMap(ServerEvents::getUuidFromFile, file -> new ServerStatsCounter(server, file)));
    }

    private static UUID getUuidFromFile(File file) {
        return UUID.fromString(file.getName().split(".json")[0]);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ServerPlayer playerEntity = (ServerPlayer)event.getEntity();
            playerStatMap.put(playerEntity.m_20148_(), PlayerStat.from(playerEntity.m_20148_(), playerEntity.m_36316_().getName(), (StatsCounter)playerEntity.m_8951_(), true));
            PacketHandler.sendToAll(new PacketPlayers(playerStatMap));
        }
    }

    public static long getLastSeenAdjusted(UUID uuid) {
        if (EffectiveSide.get().isServer()) {
            long lastSeen = LAST_SEEN_MAP.getOrDefault(uuid.toString(), -1L);
            if (lastSeen != -1L) {
                lastSeen = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC) - lastSeen;
            }
            return lastSeen;
        }
        throw new IllegalStateException("Trying to get homes on non server side");
    }

    private static void loadLastSeen(ServerLevel world) {
        File warpDir = FileUtil.getDirRelativeToWorldFolder(world, "/tabstats");
        Type type = new TypeToken<ConcurrentHashMap<String, Long>>(){}.getType();
        LAST_SEEN_MAP = FileUtil.load(warpDir, "/lastseen.json", type, ConcurrentHashMap::new);
    }

    public static void saveLastSeen(ServerLevel world) {
        File warpDir = FileUtil.getDirRelativeToWorldFolder(world, "/tabstats");
        Type type = new TypeToken<ConcurrentHashMap<String, Long>>(){}.getType();
        FileUtil.save(warpDir, "/lastseen.json", LAST_SEEN_MAP, type);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            ServerPlayer playerEntity = (ServerPlayer)event.getEntity();
            LAST_SEEN_MAP.put(playerEntity.m_20148_().toString(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
            if (playerEntity.m_20194_() != null) {
                ServerEvents.saveLastSeen(playerEntity.m_20194_().m_129783_());
            }
            PacketHandler.sendToAll(new PacketPlayers(playerStatMap));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        try {
            ServerLevel world = event.getServer().m_129783_();
            ServerEvents.loadLastSeen(world);
        }
        catch (Exception e) {
            TabStats.LOGGER.error(e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onServerShutdown(ServerStoppingEvent event) {
        try {
            ServerLevel world = event.getServer().m_129783_();
            ServerEvents.saveLastSeen(world);
        }
        catch (Exception e) {
            TabStats.LOGGER.error(e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onBackupTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_6846_().m_11309_() == 0) {
            backupTicks = 0;
            return;
        }
        if (backupTicks % 6000 == 0) {
            ServerLevel world = server.m_129783_();
            ServerEvents.saveLastSeen(world);
            backupTicks = 1;
            return;
        }
        ++backupTicks;
    }
}

